<?php

namespace App\System\Module;

use App\System\Basic\beRouter;
use App\System\Controller\CartController;
use App\System\Controller\NavController;
use App\System\Model\CurrencyModel;
use App\System\Model\ModuleLogModel;
use App\System\Model\ProductAddonTranslationsModel;
use App\System\Model\ProductModel;
use App\System\Model\SettingModel;
use App\System\Model\UserProductModel;
use App\System\Vendor\Auth;
use App\System\Vendor\Basic\beCookie;
use App\System\Vendor\beLanguage;
use App\System\Vendor\beModule;

class cpanel {
    public $pages = [
        "/" => [
            "showmenu" => true,
            "name" => "Ana Sayfa",
            "icon" => "<i class=\"ri-home-line\"></i>"
        ],
        "islem-kayitlari" => [
            "showmenu" => true,
            "name" => "İşlem Kayıtları",
            "icon" => "<i class=\"ri-history-line\"></i>",
            "function" => "cpanel_clientarea_logs"
        ],
        "format" => [
            "showmenu" => true,
            "name" => "Format",
            "icon" => "<i class=\"ri-format-clear\"></i>",
            "function" => "cpanel_clientarea_format"
        ]
    ];
    public function cpanel_permissions($data = []){
        return [
            [
                "ugpname" => "Sipariş Üzerinde Hesap Bilgilerini Görüntüleme",
                "ugptype" => "bool",
                "ugpcode" => "cpanel_show_info",
            ],
            [
                "ugpname" => "Sipariş Üzerinde WHM Girişi Yapabilir",
                "ugptype" => "bool",
                "ugpcode" => "cpanel_login_whm",
            ],
            [
                "ugpname" => "Sipariş Üzerinde cPanel Girişi Yapabilir",
                "ugptype" => "bool",
                "ugpcode" => "cpanel_login_cpanel",
            ],
            [
                "ugpname" => "Sipariş Üzerinde WebMail Girişi Yapabilir",
                "ugptype" => "bool",
                "ugpcode" => "cpanel_login_webmail",
            ],
            [
                "ugpname" => "Sipariş Üzerinde Hesabı Tekrar Kurabilir",
                "ugptype" => "bool",
                "ugpcode" => "cpanel_format",
            ]
        ];
    }
    public function cpanel_info(){
        return [
            "name" => "cPanel",
            "description" => "cPanel ile gerekli bağlantıyı kurup otomasyon sağlar",
            "version" => "1.0",
            "vercode" => 10,
            "type" => "webhost",
            "status" => 1,
            "author" => "ITenGriTR"
        ];
    }
    public function cpanel_connection_test($params = []){
        $response = $this->beSendApiRequest([
            "apiurl" => $params["surl"],
            "method" => "listaccts",
            "data" => [
                "login_username" => $params["susername"],    
                "login_token" => $params["stoken"],
            ]
        ]);
        if(!$response["data"]["acct"][0]){
            return ["status" => false,"message" => "Erişim sağlanamadı veya girilen bilgiler yanlış. Lütfen kontrol sağlayınız"];
        }
        return ["status" => true];
    }
    public function cpanel_order_config(){
        return [
            "domain" => [
                "name" => "Alan Adı",
                "description" => "Kullanıcının yöneteceği temel alan adı",
                "type" => "string",
                "default" => ""
            ],
            "reseller" => [
                "name" => "Satıcı Hesabı",
                "description" => "Hesabın satıcı hesabı olup olmadığını belirleyiniz",
                "type" => "select",
                "status" => 1,
                "default" => 1,
                "values" => [
                    0 => "Normal",
                    1 => "Satıcı"
                ]
            ],
            "username" => [
                "name" => "Kullanıcı Adı",
                "description" => "cPanel üzerinde ve WHM girişinde kullanılacak olan kullanıcı adı",
                "type" => "string",
                "default" => ""
            ]
        ];
    }
    public function cpanel_product_config($params = []){
        return [
            "planname" => [
                "name" => "Plan Adı",
                "description" => "Plan adını giriniz(Cpanel Üzerindeki)",
                "type" => "string",
                "default" => "",
                "form-view" => [
                    "class" => "col-4" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
            "reseller" => [
                "name" => "Reseller",
                "description" => "Bu ürünün Reseller olarak yönetilmesi için 1 istemiyorsanız 0 giriniz",
                "type" => "integer",
                "default" => "",
                "form-view" => [
                    "class" => "col-4" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
            "reselleraccount" => [
                "name" => "Reseller Hesap Sayısı",
                "description" => "Bu ürünün Reseller olduğunda açabiliceği hesap sayısı",
                "type" => "integer",
                "default" => "",
                "form-view" => [
                    "class" => "col-4" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
            "resellerdisk" => [
                "name" => "Reseller Disk GB",
                "description" => "Bu ürünün Reseller olduğunda toplam disk alanı(-1 Sınırsız)",
                "type" => "integer",
                "default" => "",
                "form-view" => [
                    "class" => "col-4" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
            "resellerbandwith" => [
                "name" => "Reseller Bant Genişliği GB",
                "description" => "Bu ürünün Reseller olduğunda toplam bant genişliği(-1 Sınırsız)",
                "type" => "integer",
                "default" => "",
                "form-view" => [
                    "class" => "col-4" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ]
        ];
    }
    public function cpanel_addon_config($params = []){
        return [        
            "diskgb" => [
                "name" => "Disk GB",
                "description" => "Verilecek disk miktarını(GB) olarak belirleyiniz",
                "type" => "integer",
                "default" => "",
                "form-view" => [
                    "class" => "col-6" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
            "trafficgb" => [
                "name" => "Trakif GB",
                "description" => "Verilecek trafik miktarını(GB) olarak belirleyiniz",
                "type" => "integer",
                "default" => "",
                "form-view" => [
                    "class" => "col-6" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
            "addondomain" => [
                "name" => "Addon Domain Sayısı",
                "description" => "Verilecek addon domain miktarını(ADET) olarak belirleyiniz",
                "type" => "integer",
                "default" => "",
                "form-view" => [
                    "class" => "col-6" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
            "dedicatedip" => [
                "name" => "Dedicated IP",
                "description" => "Dedicated IP adresi verilmesi için 1 giriniz",
                "type" => "integer",
                "default" => "",
                "form-view" => [
                    "class" => "col-6" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
        ];
    }
    public function cpanel_content_up($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        if($updata["reseller"] == 1){
            $response = $this->beSendApiRequest([
                "apiurl" => $params["server"]["surl"],
                "method" => "create_user_session",
                "data" => [
                    "login_username" => $params["server"]["susername"],    
                    "login_token" => $params["server"]["stoken"],
                    "service" => "whostmgrd",
                    "user" => $updata["username"]
                ]
            ]);
            $loginlinks["whostmgrd"] = "";
            if($response["data"]["url"]){
                $loginlinks["whostmgrd"] = $response["data"]["url"];
                $loginlinks["whostmgrd"] = preg_replace('/\/\/(.*):/',"//".$params["server"]["surl"].":",$loginlinks["whostmgrd"]);
            }
            else{
                $loginlinks["whostmgrd_error"] = $response["metadata"]["reason"];
            }
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "create_user_session",
            "data" => [
                "login_username" => $params["server"]["susername"],    
                "login_token" => $params["server"]["stoken"],
                "service" => "cpaneld",
                "user" => $updata["username"]
            ]
        ]);
        $loginlinks["cpanel"] = "";
        if($response["data"]["url"]){
            $loginlinks["cpanel"] = $response["data"]["url"];
            $loginlinks["cpanel"] = preg_replace('/\/\/(.*):/',"//".$params["server"]["surl"].":",$loginlinks["cpanel"]);
        }
        else{
            $loginlinks["cpanel_error"] = $response["metadata"]["reason"];
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "create_user_session",
            "data" => [
                "login_username" => $params["server"]["susername"],    
                "login_token" => $params["server"]["stoken"],
                "service" => "webmaild",
                "user" => $updata["username"]
            ]
        ]);
        $loginlinks["webmail"] = "";
        if($response["data"]["url"]){
            $loginlinks["webmail"] = $response["data"]["url"];
        }
        else{
            $loginlinks["webmail_error"] = $response["metadata"]["reason"];
        }
        return beGetView("modules.cpanel.contentup",["userproduct" => $userproduct,"updata" => $updata,"loginlinks" => $loginlinks]);
    }
    public function cpanel_preconfiguration($params){
        beLanguage::beReadLang("module");
        $addonname = "";
        foreach($params["productaddons"] as $addon){
            if($addon["pacode"] == "domain_name"){
                $addonname = $addon["paid"];
                break;
            }
        }
        if(!$addonname){
            echo beAjaxError(["message" => "cPanel modülünün kullanılabilmesi için domain_name kodlu Ürün Yapılandırması'nın olması gerekmektedir!"]);
            exit;
        }
        if(!$_COOKIE[$addonname]){
            if($_GET["domaintype"]){
                switch($_GET["domaintype"]){
                    case "newdomain" :
                        $settings = SettingModel::beGetSettings("domain_status");
                        if(!$settings["domain_status"]){
                            echo beAjaxError(["message" => "Alan adı sistemi şuan için aktif değil lütfen mevcut seçeneği ile devam ediniz."]);
                            exit;
                        }
                        beLanguage::beReadLang("module");
                        $modules = beModule::beLoadModules("product");
                        $module = "";
                        foreach($modules as $key => $data){
                            if($data["info"]["type"] == "domain" && $data["info"]["status"] == 1){
                                $module = $key;
                                break;
                            }
                        }
                        if(!$module){
                            echo beAjaxError(["message" => beGetLang("module_not_found")]);
                            exit;
                        }
                        $product = ProductModel::beSelect("pid")->beWhere("pmodule",$module)->beGet();
                        if(!$product){
                            echo beAjaxError(["message" => "Alan adı satın alımı için ürün bulunamadı!."]);
                            exit;
                        }
                        if(!beModule::beCheckModuleFunction($module,"checkdomain")){
                            echo beAjaxError(["message" => beGetLang("module_not_support")]);
                            exit;
                        }
                        $extension = $_GET["domainextension"];
                        $domain = $_GET["domainname1"];
                        $maindomain = $domain.$extension;
                        $response = beModule::beRunModuleFunction($module,"checkdomain",[$maindomain]);
                        if(!$response["status"]){
                            echo beAjaxError(["message" => beGetLang("module_function_error")]);
                            exit;
                        }
                        if(!$response["domains"][0]["available"]){
                            echo beAjaxError(["message" => "Belirtilen alan adı dolu gözüküyor lütfen başka eşsiz bir alan adı giriniz!"]);
                            exit;
                        }
                        $user = Auth::beGetUser();
                        $domain_extension = ProductAddonTranslationsModel::beSelect("patid,paid,paoptions")->beWhere("lid",$user["lid"])->beWhere("pacode","domain_extension")->beGet();
                        $domain_name = ProductAddonTranslationsModel::beSelect("patid,paid")->beWhere("lid",$user["lid"])->beWhere("pacode","domain_name")->beGet();
                        $paoptions = json_decode($domain_extension["paoptions"],true);
                        $addonkey = -1;
                        foreach($paoptions as $key => $option){
                            if($extension == $option["oname"]){
                                $addonkey = $key;
                                break;
                            }
                        }
                        if($addonkey == -1){
                            echo beAjaxError(["message" => "Belirtilen alan adı uzantısı sistem üzerinde satılmamaktadır."]);
                            exit;
                        }
                        $item = [];
                        $item[(int)$domain_extension["paid"]] = $addonkey;
                        $item[(int)$domain_name["paid"]] = $domain;
                        $item["period"] = 1;
                        $item["pid"] = $product["pid"];
                        $cartcontroller = new CartController();
                        $response = $cartcontroller->additem_post($item);
                        $response = json_decode($response,true);
                        if(!$response["status"]){
                            echo beAjaxError(["message" => $response["message"]]);
                            exit;
                        }
                        beCookie::beCreateCookie($addonname,$domain,true,true,BE_TIME+120);
                        echo beAjaxSuccess(["message" => $response["message"],"refresh" => 1]);
                        exit;
                        break;
                    case "transferdomain" :
                        echo beAjaxError(["message" => "Alan adı transfer sistemi şuan için aktif değil lütfen yeni yada mevcut seçeneği ile devam ediniz."]);
                        exit;
                        $domain = $_GET["domainname2"];
                        if(strpos($domain,".") === false){
                            echo beAjaxError(["message" => "Alan adı formatı doğru değil lütfen <b>".beGetConfig("sitename")."</b> tarzında alan adınızı giriniz"]);
                            exit;
                        }
                        $response = $this->beSendApiRequest([
                            "apiurl" => $params["server"]["surl"],
                            "method" => "listaccts",
                            "data" => [
                                "login_username" => $params["server"]["susername"],    
                                "login_token" => $params["server"]["stoken"],
                                "search" => $domain,
                                "searchmethod" => "exact",
                                "searchtype" => "domain"
                            ]
                        ]);
                        if($response["data"]["acct"][0]){
                            echo beAjaxError(["message" => "Belirtilen alan adı sistem üzerinde bulunmaktadır lütfen başka bir alan adı giriniz."]);
                            exit;
                        }
                        beCookie::beCreateCookie($addonname,$domain,true,true,BE_TIME+120);
                        echo beAjaxSuccess(["message" => "Başarılı bir şekilde ürün yapılandırıldı!","refresh" => 1]);
                        exit;
                        break;
                    case "changedomain" :
                        $domain = $_GET["domainname3"];
                        if(strpos($domain,".") === false){
                            echo beAjaxError(["message" => "Alan adı formatı doğru değil lütfen <b>".beGetConfig("sitename")."</b> tarzında alan adınızı giriniz"]);
                            exit;
                        }
                        $response = $this->beSendApiRequest([
                            "apiurl" => $params["server"]["surl"],
                            "method" => "listaccts",
                            "data" => [
                                "login_username" => $params["server"]["susername"],    
                                "login_token" => $params["server"]["stoken"],
                                "search" => $domain,
                                "searchmethod" => "exact",
                                "searchtype" => "domain"
                            ]
                        ]);
                        if($response["data"]["acct"][0]){
                            echo beAjaxError(["message" => "Belirtilen alan adı sistem üzerinde bulunmaktadır lütfen başka bir alan adı giriniz."]);
                            exit;
                        }
                        beCookie::beCreateCookie($addonname,$domain,true,true,BE_TIME+120);
                        echo beAjaxSuccess(["message" => "Başarılı bir şekilde ürün yapılandırıldı!","refresh" => 1]);
                        exit;
                        break;
                }
            }
            else{
                NavController::beAddBreadcumb("Alan Adı Yapılandırması");
                beSetHeaderContent();
                bePrintPage(beGetView("modules.cpanel.selectdomain"));
                exit;
            }
        }
    }
    public function cpanel_create($params = []){
        clearstatcache();
        $userproduct = $params["userproduct"];
        $upoptions = json_decode($userproduct["upoptions"],true);
        $domain = "";
        foreach($upoptions as $option => $data){
            if($data["code"] == "domain_name"){
                $domain = $data["key"];
                break;
            }
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "listaccts",
            "data" => [
                "login_username" => $params["server"]["susername"],    
                "login_token" => $params["server"]["stoken"],
                "search" => $domain,
                "searchmethod" => "exact",
                "searchtype" => "domain"
            ]
        ]);
        if($response["data"]["acct"][0]){
            return ["status" => false,"message" => "Belirtilen alan adı sistem üzerinde bulunmaktadır lütfen yönetici ile iletişime geçiniz."];
        }
        $siteshortname = strtolower(str_replace(" ","",beGetConfig("siteshortname")));
        $siteshortname = str_replace(["İ","Ü","Ö","Ğ","Ç","Ş","ı","ü","ö","ğ","ç","ş"],["I","U","O","G","C","S","i","u","o","g","c","s"],$siteshortname);
        if(strlen($siteshortname) > 8){
            $siteshortname = substr($siteshortname,0,8);
        }
        $response["data"]["acct"][0] = 1;
        while(isset($response["data"]["acct"][0])){
            $username = $siteshortname.substr(md5(BE_TIME.$userproduct["upid"].rand(0,1000)),0,8);
            $response = $this->beSendApiRequest([
                "apiurl" => $params["server"]["surl"],
                "method" => "listaccts",
                "data" => [
                    "login_username" => $params["server"]["susername"],    
                    "login_token" => $params["server"]["stoken"],
                    "search" => $username,
                    "searchtype" => "user",
                ]
            ]);
            break;
        }
        if(!$params["productmodules"]["reseller"]){
            $params["productmodules"]["reseller"] = 0;
        }
        $password = substr(md5(rand(0,1000).$userproduct["upid"].rand(0,1000)),0,10)."!@".$siteshortname;
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "createacct",
            "data" => [
                "login_username" => $params["server"]["susername"],    
                "login_token" => $params["server"]["stoken"],
                "domain" => $domain,
                "username" => $username,
                "password" => $password,
                "plan" => $params["productmodules"]["planname"],
                "reseller" => $params["productmodules"]["reseller"],
                "quota" => $params["addonmodules"]["diskgb"][0]*1024,
                "bwlimit" => $params["addonmodules"]["trafficgb"][0]*1024,
                "maxaddon" => $params["addonmodules"]["addondomain"][0],
                "ip" => isset($params["addonmodules"]["dedicatedip"][0]) == 1 ? "y":"n",
            ]
        ]);
        if($response["metadata"]["reason"] != "Account Creation Ok"){
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"cpanel","Kurulum Hatası","Kurulum esnasında bir sorun oluştu!",[
                "response" => $response
            ]);
            return ["status" => false,"message" => "cPanel kurulumunda bir sorun oluştu lütfen yönetici ile iletişime geçiniz."];
        }
        if($params["productmodules"]["reseller"] == 1){
            $this->beSendApiRequest([
                "apiurl" => $params["server"]["surl"],
                "method" => "setacls",
                "data" => [
                    "login_username" => $params["server"]["susername"],    
                    "login_token" => $params["server"]["stoken"],
                    "reseller" => $username,
                    "acllist" => "resellerdefault"
                ]
            ]);
            $extradata = [];
            if($params["productmodules"]["resellerdisk"] != -1){
                $extradata["enable_resource_limits"] = 1;
                $extradata["diskspace_limit"] = $params["productmodules"]["resellerdisk"]*1024;
            }
            if($params["productmodules"]["resellerbandwith"] != -1){
                $extradata["enable_resource_limits"] = 1;
                $extradata["bandwidth_limit"] = $params["productmodules"]["resellerbandwith"]*1024;
            }
            else{
                $extradata["enable_overselling"] = 1;
                $extradata["enable_overselling_bandwidth"] = 1;
                $extradata["bandwidth_limit"] = 1024000;
            }
            $this->beSendApiRequest([
                "apiurl" => $params["server"]["surl"],
                "method" => "setresellerlimits",
                "data" => array_merge([
                    "login_username" => $params["server"]["susername"],    
                    "login_token" => $params["server"]["stoken"],
                    "user" => $username,
                    "enable_account_limit" => 1,
                    "account_limit" => $params["productmodules"]["reselleraccount"]
                ],$extradata)
            ]);
            if($params["addonmodules"]["dedicatedip"][0] == 1){
                $response = $this->beSendApiRequest([
                    "apiurl" => $params["server"]["surl"],
                    "method" => "accountsummary",
                    "data" => [
                        "login_username" => $params["server"]["susername"],    
                        "login_token" => $params["server"]["stoken"],
                        "domain" => $domain,
                        "user" => $username
                    ]
                ]);
                $ipaddress = $response["data"]["acct"][0]["ip"];
                $this->beSendApiRequest([
                    "apiurl" => $params["server"]["surl"],
                    "method" => "setresellerips",
                    "data" => [
                        "login_username" => $params["server"]["susername"],    
                        "login_token" => $params["server"]["stoken"],
                        "user" => $username,
                        "delegate" => 1,
                        "ips" => $ipaddress
                    ]
                ]);
                $this->beSendApiRequest([
                    "apiurl" => $params["server"]["surl"],
                    "method" => "setresellerips",
                    "data" => [
                        "login_username" => $params["server"]["susername"],    
                        "login_token" => $params["server"]["stoken"],
                        "user" => $username,
                        "ip" => $ipaddress
                    ]
                ]);
            }
        }
        $updatedata = [];
        $updatedata["uptag"] = $domain;
        $updata = [
            "domain" => $domain,
            "username" => $username,
            "password" => $password,
            "plan" => $params["productmodules"]["planname"],
            "reseller" => $params["productmodules"]["reseller"]
        ];
        $updatedata["updata"] = json_encode($updata,JSON_UNESCAPED_UNICODE);
        UserProductModel::beUpdate($updatedata)->beWhere("upid",$userproduct["upid"])->beExecute();
        return ["status" => true,"message" => "Ürün yönetim paneline yönlendiliriliyorsunuz","url" => beGetRoute("client.userproduct.userproduct.show",["upid" => $userproduct["upid"]])];
    }
    public function cpanel_manage($params = []){
        $userproduct = $params["userproduct"];
        beCookie::beCreateCookie("be_upid",$userproduct["upid"],true,true);
        return ["status" => true,"message" => "Ürün yönetim paneline yönlendiliriliyorsunuz","url" => beGetRoute("client.userproduct.userproduct.show",["upid" => $userproduct["upid"]])];
    }
    public function cpanel_extend($params = []){
        return ["status" => true];
    }
    public function cpanel_suspend($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "suspendacct",
            "data" => [
                "login_username" => $params["server"]["susername"],    
                "login_token" => $params["server"]["stoken"],
                "user" => $updata["username"]
            ]
        ]);
        if($response["metadata"]["result"] != 1){
            return ["status" => false,"message" => $response["metadata"]["reason"]];
        }
        return ["status" => true,"message" => "Başarılı bir şekilde sipariş modül üzerinde askıya alındı!"];
    }
    public function cpanel_unsuspend($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "unsuspendacct",
            "data" => [
                "login_username" => $params["server"]["susername"],    
                "login_token" => $params["server"]["stoken"],
                "user" => $updata["username"]
            ]
        ]);
        if($response["metadata"]["result"] != 1){
            return ["status" => false,"message" => $response["metadata"]["reason"]];
        }
        return ["status" => true,"message" => "Başarılı bir şekilde sipariş modül üzerinde askıdan kaldırıldı!"];
    }
    public function cpanel_terminate($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        if($params["productmodules"]["reseller"] == 1){
            $response = $this->beSendApiRequest([
                "apiurl" => $params["server"]["surl"],
                "method" => "terminatereseller",
                "data" => [
                    "login_username" => $params["server"]["susername"],    
                    "login_token" => $params["server"]["stoken"],
                    "terminatereseller" => "1",
                    "username" => $updata["username"]
                ]
            ]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "removeacct",
            "data" => [
                "login_username" => $params["server"]["susername"],    
                "login_token" => $params["server"]["stoken"],
                "username" => $updata["username"]
            ]
        ]);
        if($response["metadata"]["result"] != 1){
            return ["status" => false,"message" => $response["metadata"]["reason"]];
        }
        return ["status" => true,"message" => "Başarılı bir şekilde sipariş modül üzerinde silindi!"];
    }
    public function cpanel_clientarea($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $url = $params["url"];
        $page = $params["page"];
        beLanguage::beReadLang("cpanel");
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "accountsummary",
            "data" => [
                "login_username" => $params["server"]["susername"],    
                "login_token" => $params["server"]["stoken"],
                "user" => $updata["username"]
            ]
        ]);
        $account = $response["data"]["acct"][0];
        $upoptions = json_decode($userproduct["upoptions"],true);
        $currencie = CurrencyModel::beGetCurrencies("cicon",$userproduct["cid"]);
        $orderinfo = [
            "product" => $userproduct["pname"],
            "billingprice" => $upoptions["period"]["price"],
            "billingcycle" => ProductModel::beGetPeriods()[$upoptions["period"]["period"]],
            "regdate" => date("d.m.Y",$userproduct["upstime"]),
            "nextduedate" => date("d.m.Y",$userproduct["upntime"]),
            "amount" => $userproduct["upprice"],
            "currencie" => $currencie
        ];
        if(preg_match("/GB/",$account["diskused"])){
            $account["diskused"] = (int)str_replace("GB","",$account["diskused"])*1024;
        }
        if(preg_match("/GB/",$account["disklimit"])){
            $account["disklimit"] = (int)str_replace("GB","",$account["disklimit"])*1024;
        }
        $usageinfo = [
            "inode_usage" => $account["inodesused"],
            "inode_max" => $account["inodeslimit"],
            "inode_percent" => round($account["inodesused"]*100/$account["inodeslimit"],2),
            "disk_usage" => $account["diskused"],
            "disk_max" => $account["disklimit"],
            "disk_percent" => round($account["diskused"]*100/$account["disklimit"],2),
        ];
        if($account["inodeslimit"] == "unlimited"){
            $usageinfo["inode_percent"] = 100;
            $usageinfo["inode_max"] = "Sınırsız";
        }
        if($updata["reseller"] == 1){
            $response = $this->beSendApiRequest([
                "apiurl" => $params["server"]["surl"],
                "method" => "create_user_session",
                "data" => [
                    "login_username" => $params["server"]["susername"],    
                    "login_token" => $params["server"]["stoken"],
                    "service" => "whostmgrd",
                    "user" => $updata["username"]
                ]
            ]);
            $loginlinks["whostmgrd"] = "";
            if($response["data"]["url"]){
                $loginlinks["whostmgrd"] = $response["data"]["url"];
                $loginlinks["whostmgrd"] = preg_replace('/\/\/(.*):/',"//".$params["server"]["surl"].":",$loginlinks["whostmgrd"]);
            }
            else{
                ModuleLogModel::beCreateModuleLog($userproduct["upid"],"cpanel","","cPanel giriş(WHM) link sisteminde bir sorun oluştu!",[
                    "response" => $response
                ]);
                $loginlinks["whostmgrd_error"] = $response["metadata"]["reason"];
            }
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "create_user_session",
            "data" => [
                "login_username" => $params["server"]["susername"],    
                "login_token" => $params["server"]["stoken"],
                "service" => "cpaneld",
                "user" => $updata["username"]
            ]
        ]);
        $loginlinks["cpanel"] = "";
        if($response["data"]["url"]){
            $loginlinks["cpanel"] = $response["data"]["url"];
            $loginlinks["cpanel"] = preg_replace('/\/\/(.*):/',"//".$params["server"]["surl"].":",$loginlinks["cpanel"]);
        }
        else{
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"cpanel","","cPanel giriş(cPanel) link sisteminde bir sorun oluştu!",[
                "response" => $response
            ]);
            $loginlinks["cpanel_error"] = $response["metadata"]["reason"];
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "create_user_session",
            "data" => [
                "login_username" => $params["server"]["susername"],    
                "login_token" => $params["server"]["stoken"],
                "service" => "webmaild",
                "user" => $updata["username"]
            ]
        ]);
        $loginlinks["webmail"] = "";
        if($response["data"]["url"]){
            $loginlinks["webmail"] = $response["data"]["url"];
        }
        else{
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"cpanel","","cPanel giriş(WebMail) link sisteminde bir sorun oluştu!",[
                "response" => $response
            ]);
            $loginlinks["webmail_error"] = $response["metadata"]["reason"];
        }
        if($page){
            $pageinfo = $this->pages[$page];
            if($pageinfo){
                $params["title"] = $pageinfo["name"];
                NavController::beAddBreadcumb($pageinfo["name"]);
                $function = $pageinfo["function"];
                $content = $this->$function($params);
            }
            else{
                $content = "Bu sayfa bulunamadı!";
            }
        }
        else{
            $content = beGetView("modules.cpanel.show",[
                "userproduct" => $userproduct,
                "updata" => $updata,
                "server" => $params["server"],
                "orderinfo" => $orderinfo,
                "usageinfo" => $usageinfo,
                "loginlinks" => $loginlinks,
            ]);
        }
        $altmenu = [];
        $menuitems = [];
        foreach($this->pages as $pageurl => $data){
            if(!$data["showmenu"]){
                continue;
            }
            $texturl = "";
            if($pageurl == "/"){
                $texturl = $url;
            }
            else{
                $texturl = $url."/".$pageurl;
            }
            $menuitems[] = [
                "name" => $data["name"],
                "icon" => $data["icon"],
                "url" => $texturl
            ];
        }
        $altmenu[] = [
            "name" => "cPanel Yönetimi",
            "menuitems" => $menuitems
        ];
        return [
            "status" => true,
            "title" => "Hosting Yönetimi",
            "content" => $content,
            "menus" => $altmenu
        ];
    }
    public function cpanel_login_session($params){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $application = $_POST["application"];
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "create_user_session",
            "data" => [
                "login_username" => $params["server"]["susername"],    
                "login_token" => $params["server"]["stoken"],
                "service" => "cpaneld",
                "user" => $updata["username"],
                "app" => $application
            ]
        ]);
        $url = $response["data"]["url"];
        $url = preg_replace('/\/\/(.*):/',"//".$params["server"]["surl"].":",$url);
        ModuleLogModel::beCreateModuleLog($userproduct["upid"],"cpanel","Hızlı Giriş Yönlendirme","cPanel hesabı kullanıcı hızlı giriş kullanarak giriş yaptı!",[
            "application" => $application,
            "url" => $url,
            "ipaddress" => beRouter::$beUserIP,
        ],"0");
        return beAjaxSuccess(["message" => "Başarılı bir şekilde işlem sağlandı!","url" => $url]);
    }
    public function cpanel_clientarea_logs($params){
        $userproduct = $params["userproduct"];
        $user = Auth::beGetUser();
        $page = (int)$_GET["page"];
        if(!$page){
            $page = 1;
        }
        $itemcount = ModuleLogModel::beSelect("COUNT(mlid) as total")->beWhere("upid",$userproduct["upid"])->beWhere("mlonlyadmin","0")->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,$params["url"],15,"user");
        $items = ModuleLogModel::beSelect("mlid,mlname,mldescription,mldata,mldateline")->beWhere("upid",$userproduct["upid"])->beWhere("mlonlyadmin","0");
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $items = $items->beOrder("mlid","DESC")->beGetAll();
        beSetHeaderContent("",1);
        return beGetView("modules.cpanel.logs",["items" => $items,"itemcount" => $itemcount,"paganation" => $paganation]);
    }
    public function cpanel_clientarea_format($params){
        return beGetView("modules.cpanel.format",["userproduct" => $params["userproduct"]]);
    }
    public function cpanel_format($params){
        $userproduct = $params["userproduct"];
        if(!$_POST["approval"]){
            return beAjaxError(["message" => "Lütfen tüm bilgilerinizin siliniceğini onaylayın!"]);
        }
        $updata = json_decode($userproduct["updata"],true);
        $password = $_POST["password"];
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "removeacct",
            "data" => [
                "login_username" => $params["server"]["susername"],    
                "login_token" => $params["server"]["stoken"],
                "username" => $updata["username"]
            ]
        ]);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "createacct",
            "data" => [
                "login_username" => $params["server"]["susername"],    
                "login_token" => $params["server"]["stoken"],
                "domain" => $updata["domain"],
                "username" => $updata["username"],
                "password" => $password,
                "plan" => $params["productmodules"]["planname"],
                "quota" => $params["addonmodules"]["diskgb"][0]*1024,
                "bwlimit" => $params["addonmodules"]["trafficgb"][0]*1024,
                "maxaddon" => $params["addonmodules"]["addondomain"][0],
                "ip" => isset($params["addonmodules"]["dedicatedip"][0]) == 1 ? "y":"n",
            ]
        ]);
        if($response["metadata"]["reason"] != "Account Creation Ok"){
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"cpanel","Kurulum Hatası","Kurulum esnasında bir sorun oluştu!",[
                "response" => $response
            ]);
            return beAjaxError(["message" => "cPanel kurulumunda bir sorun oluştu lütfen yönetici ile iletişime geçiniz."]);
        }
        if($params["productmodules"]["reseller"] == 1){
            $this->beSendApiRequest([
                "apiurl" => $params["server"]["surl"],
                "method" => "setacls",
                "data" => [
                    "login_username" => $params["server"]["susername"],    
                    "login_token" => $params["server"]["stoken"],
                    "reseller" => $updata["username"],
                    "acllist" => "resellerdefault"
                ]
            ]);
            $extradata = [];
            if($params["productmodules"]["resellerdisk"] != -1){
                $extradata["enable_resource_limits"] = 1;
                $extradata["diskspace_limit"] = $params["productmodules"]["resellerdisk"]*1024;
            }
            if($params["productmodules"]["resellerbandwith"] != -1){
                $extradata["enable_resource_limits"] = 1;
                $extradata["bandwidth_limit"] = $params["productmodules"]["resellerbandwith"]*1024;
            }
            else{
                $extradata["enable_overselling"] = 1;
                $extradata["enable_overselling_bandwidth"] = 1;
                $extradata["bandwidth_limit"] = 1024000;
            }
            $this->beSendApiRequest([
                "apiurl" => $params["server"]["surl"],
                "method" => "setresellerlimits",
                "data" => array_merge([
                    "login_username" => $params["server"]["susername"],    
                    "login_token" => $params["server"]["stoken"],
                    "user" => $updata["username"],
                    "enable_account_limit" => 1,
                    "account_limit" => $params["productmodules"]["reselleraccount"]
                ],$extradata)
            ]);
            if($params["addonmodules"]["dedicatedip"][0] == 1){
                $response = $this->beSendApiRequest([
                    "apiurl" => $params["server"]["surl"],
                    "method" => "accountsummary",
                    "data" => [
                        "login_username" => $params["server"]["susername"],    
                        "login_token" => $params["server"]["stoken"],
                        "domain" => $updata["domain"],
                        "user" => $updata["username"]
                    ]
                ]);
                $ipaddress = $response["data"]["acct"][0]["ip"];
                $this->beSendApiRequest([
                    "apiurl" => $params["server"]["surl"],
                    "method" => "setresellerips",
                    "data" => [
                        "login_username" => $params["server"]["susername"],    
                        "login_token" => $params["server"]["stoken"],
                        "user" => $updata["username"],
                        "delegate" => 1,
                        "ips" => $ipaddress
                    ]
                ]);
                $this->beSendApiRequest([
                    "apiurl" => $params["server"]["surl"],
                    "method" => "setresellerips",
                    "data" => [
                        "login_username" => $params["server"]["susername"],    
                        "login_token" => $params["server"]["stoken"],
                        "user" => $updata["username"],
                        "ip" => $ipaddress
                    ]
                ]);
            }
        }
        ModuleLogModel::beCreateModuleLog($userproduct["upid"],"cpanel","cPanel Hesap Sıfırlaması","cPanel hesabı kullanıcı tarafından sıfırlandı!",[
            "ipaddress" => beRouter::$beUserIP
        ],"0");
        $updata["password"] = $password;
        UserProductModel::beUpdate(["updata" => json_encode($updata,JSON_UNESCAPED_UNICODE)])->beWhere("upid",$userproduct["upid"])->beExecute();
        return beAjaxSuccess(["message" => "Başarılı bir şekilde hostinginiz sıfırlandı!"]);
    }

    public function beSendApiRequest($data = []){
        $ch = curl_init();
        $username = $data["data"]["login_username"];
        $token = $data["data"]["login_token"];
        unset($data["data"]["login_username"]);
        unset($data["data"]["login_token"]);
        curl_setopt($ch,CURLOPT_URL,"https://{$data['apiurl']}:2087/json-api/{$data['method']}?api.version=1&".http_build_query($data["data"]));
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_TIMEOUT,250);
        curl_setopt($ch,CURLOPT_HTTPHEADER,[
            "Authorization: whm {$username}:{$token}"
        ]);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        $response = curl_exec($ch);
        curl_close($ch);
        return json_decode($response,true);
    }
}