<?php

namespace App\System\Module;

use App\System\Basic\beModel;
use App\System\Basic\beRouter;
use App\System\Model\CurrencyModel;
use App\System\Model\SettingModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beTicket;

class bank {
    public function bank_info(){
        return [
            "name" => "Havale / Eft",
            "description" => "Havale / Eft ile ödeme almanızı sağlar",
            "version" => "1.2",
            "vercode" => 12,
            "author" => "ITenGriTR",
        ];
    }
    public function bank_is_activated(){
        $settings = SettingModel::beGetSettings("bank_status");
        return $settings["bank_status"] == 1 ? true:false;
    }
    public function bank_currency(){
        return 1;
    }
    public function bank_template($params = []){
        $settings = SettingModel::beGetSettings("bank_methodfee");
        $price = $params["total"];
        $currency = $params["currency"];
        $newprice = $price*(100+$settings["bank_methodfee"])/100;
        return beGetView("global.bank",["price" => round($newprice,2),"currency" => $currency]);
    }
    public function bank_pay_page($invoice){
        $currencies = CurrencyModel::beGetCurrencies("cid,cname,cicon");
        $settings = SettingModel::beGetSettings("bank_methodfee");
        $user = Auth::beGetUser($invoice["uid"]);
        $comussion = round($invoice["itotal"]*$settings["bank_methodfee"]/100,2);
        $invoice["itotal"] += $comussion;
         $banks = beModel::beTable("be_banks")->beGetAll();
        if(!$banks){
            return ["status" => false,"message" => "Havale/EFT ödeme yöntemi şuan için aktif değil."];
        }
        return ["status" => true,"template" => beGetView("global.bankform",["invoice" => $invoice,"currencies" => $currencies,"banks" => $banks])];
    }
    public function bank_create_payment($invoice){
        $namesurname = htmlspecialchars($_POST["user"]);
        $bid = (int)$_POST["bank"];
        $bank = beModel::beTable("be_banks")->beWhere("bid",$bid)->beGet();
        if(!$bank){
            return ["status" => false,"message" => "Belirtilen banka sistem üzerinde bulunamadı!"];
        }
        $currency = CurrencyModel::beGetCurrencies("cid,cicon",$invoice["cid"]);
        $message = "<p>Merhaba yetkili,</p><p>#{$invoice['iid']} numaralı faturamın ödemesi olan {$invoice['itotal']}{$currency['cicon']} miktarını {$bank['bname']} isimli banka hesabınıza yatırdım.</p><br><br><br><p>Yatıran Adı Soyad: {$namesurname}</p><p>Yatırılan Banka: {$bank['bname']}</p><p>Tutar: {$invoice['itotal']}{$currency['cicon']}</p>";
        $tid = beTicket::beInsertTicket([
            "uid" => $invoice["uid"],
            "upid" => 0,
            "subject" => "Ödeme Bildirimi Fatura #{$invoice['iid']}",
            "status" => "active",
            "lastreply" => "user",
            "depertment" => 0,
            "ipaddress" => beRouter::$beUserIP,
            "dateline" => BE_TIME
        ])["tid"];
        beTicket::beTicketPost([
            "tid" => $tid,
            "uid" => $invoice["uid"],
            "message" => $message,
            "files" => "[]",
            "ipaddress" => beRouter::$beUserIP,
            "dateline" => BE_TIME
        ]);
        return ["status" => true,"message" => "Başarılı bir şekilde ödeme bildiriminiz oluşturuldu","url" => beGetRoute("client.dashboard")];
    }
}
?>