<?php

namespace App\System\Module;

use App\System\Basic\beModel;
use App\System\Model\AttachmentModel;
use App\System\Model\CurrencyModel;
use App\System\Model\InvoiceModel;
use App\System\Model\ModuleLogModel;
use App\System\Model\SettingModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beLanguage;
use App\System\Vendor\bePlugin;
use App\System\Vendor\beUpload;
use Error;

class gib {
    public function gib_info(){
        return [
            "name" => "Gib Fatura Resmileştirme",
            "description" => "Sistem üzerinden yapılan satım alımları resmileştirir",
            "version" => "1.0",
            "vercode" => 10,
            "author" => "ITenGriTR"
        ];
    }
    public function gib_login(){
        $settings = SettingModel::beGetSettings("gib_username,gib_password");
        $response = [];
        for($i = 0; $i < 5; $i++){
            $response = $this->beSendRequest([
                "method" => "earsiv-services/assos-login",
                "data" => [
                    "assoscmd" => "anologin",
                    "rtype" => "json",
                    "userid" => $settings["gib_username"],
                    "sifre" => $settings["gib_password"],
                    "sifre2" => $settings["gib_password"],
                    "parola" => "1"
                ]
            ]);
            if($response["error"] == 1 && $response["messages"][0]["type"] == 5){
                return ["status" => false,"message" => "Gib fatura entegrasyonuna bilgileriniz doğru değil giriş sağlanılamadı!"];
            }
            if($response["token"]){
                break;
            }
            sleep(1);
        }
        if(!$response["token"]){
            return ["status" => false,"message" => "Gib fatura entegrasyonuna bağlanılamadı!"];
        }
        return ["status" => true,"message" => "Gib fatura entegrasyonuna başarılı bir şekilde bağlanıldı!","token" => $response["token"]];
    }
    public function gib_logout($data){
        $this->beSendRequest([
            "method" => "earsiv-services/assos-login",
            "data" => [
                "assoscmd" => "logout",
                "rtype" => "json",
                "token" => $data["token"]
            ]
        ]);
    }
    public function gib_create_invoice($data = []){
        beLanguage::beReadLang("invoice");
        $token = $data["token"];
        $resettax = false;
        if($data["userinfo"]["acid"] == 218){
            $useridentityplugin = bePlugin::beGetPlugin("useridentity");
            if(!$useridentityplugin["status"]){
                return beAjaxError(["message" => beGetLang("invoice_bill_useridentity_not_loaded")]);
            }
            $useridentity = beModel::beTable("be_user_identity")->beSelect("*")->beWhere("uid",$data["invoice"]["uid"])->beGet();
            if(!$useridentity){
                return beAjaxError(["message" => beGetLang("invoice_bill_empty_user_data")]);
            }
            $country = beModel::beTable("be_address_country")->beSelect("acid,acname,accode")->beWhere("acid",$useridentity["acid"])->beGet();
            $distric = beModel::beTable("be_address_district")->beSelect("adid,adname,adcode")->beWhere("adid",$useridentity["adid"])->beGet();
            $province = beModel::beTable("be_address_province")->beSelect("apid,apname")->beWhere("apid",$useridentity["apid"])->beGet();
        }
        else{
            $settings = SettingModel::beGetSettings("gib_global,gib_default_no");
            if($settings["gib_global"] == 0){
                return ["status" => false,"message" => "Belirtilen kullanıcının Türkiye'de kaydı bulunamıyor!"];
            }
            $country = beModel::beTable("be_address_country")->beSelect("acid,acname,accode")->beWhere("acid",$data["userinfo"]["acid"])->beGet();
            $distric["adname"] = "";
            $province["apname"] = "";
            $useridentity["uiname"] = $data["user"]["name"];
            $useridentity["uisurname"] = $data["user"]["surname"];
            $useridentity["uitcno"] = $settings["gib_default_no"];
            $useridentity["uitype"] = 1;
            $data["invoice"]["itaxprice"] = 0;
            $resettax = true;
        }
        $notlogout = $data["notlogout"];
        $invoiceuuid = $this->beCreateGuid(BE_TIME+1);
        $currency = CurrencyModel::beGetCurrencies("cid,ccode",$data["invoice"]["cid"]);
        switch($useridentity["uitype"]){
            case 1 :
                if(!$useridentity["uitcno"]){
                    return ["status" => false,"message" => "Belirtilen kullanıcının Türkiye'de kaydı bulunamıyor!"];
                }
                $requestdata = [
                    "faturaUuid" => $invoiceuuid,
                    "belgeNumarasi" => "",
                    "faturaTarihi" => date("d/m/Y",$data["datetime"]),
                    "saat" => date("H:m:s",$data["datetime"]),
                    "paraBirimi" => $currency["ccode"],
                    "dovzTLkur" => 0,
                    "faturaTipi" => "SATIS",
                    "hangiTip" =>  "5000/30000",
                    "vknTckn" => $useridentity["uitcno"],
                    "aliciUnvan" => $useridentity["uiname"]." ".$useridentity["uisurname"],
                    "aliciAdi" => $useridentity["uiname"],
                    "aliciSoyadi" => $useridentity["uisurname"],
                    "binaAdi" => "",
                    "binaNo" => "",
                    "kapiNo" => "",
                    "kasabaKoy" => "",
                    "vergiDairesi" => "",
                    "ulke" => $this->beGetCountryName($country["accode"]),
                    "bulvarcaddesokak" => $data["userinfo"]["uiaddress"],
                    "mahalleSemtIlce" => $province["apname"],
                    "sehir" => $distric["adname"],
                    "postaKodu" => "",
                    "tel" => $data["userinfo"]["uiphone"],
                    "fax" => "",
                    "eposta" => $data["user"]["email"],
                    "websitesi" => "",
                    "iadeTable" => [],
                    "ozelMatrahTutari" => "0",
                    "ozelMatrahOrani" => "0",
                    "ozelMatrahVergiTutari" => "0",
                    "vergiCesidi" => " ",
                    "malHizmetTable" => [],
                    "tip" => "İskonto",
                    "matrah" => $data["invoice"]["iprice"],
                    "malhizmetToplamTutari" => $data["invoice"]["iprice"],
                    "toplamIskonto" => "0",
                    "hesaplanankdv" => $data["invoice"]["itaxprice"],
                    "vergilerToplami" => $data["invoice"]["itaxprice"],
                    "vergilerDahilToplamTutar" => $data["invoice"]["iprice"]+$data["invoice"]["itaxprice"],
                    "odenecekTutar" => $data["invoice"]["iprice"]+$data["invoice"]["itaxprice"],
                    "not" => "",
                    "siparisNumarasi" => "",
                    "siparisTarihi" => "",
                    "irsaliyeNumarasi" => "",
                    "irsaliyeTarihi" => "",
                    "fisNo" => "",
                    "fisTarihi" => "",
                    "fisSaati" => "",
                    "fisTipi" => "",
                    "zRaporNo" => "",
                    "okcSeriNo" => ""
                ];
                break;
            case 2 :
                if(!$useridentity["uitaxno"]){
                    return ["status" => false,"message" => "Belirtilen kullanıcının Türkiye'de kaydı bulunamıyor!"];
                }
                $requestdata = [
                    "faturaUuid" => $invoiceuuid,
                    "belgeNumarasi" => "",
                    "faturaTarihi" => date("d/m/Y",$data["datetime"]),
                    "saat" => date("H:m:s",$data["datetime"]),
                    "paraBirimi" => $currency["ccode"],
                    "dovzTLkur" => 0,
                    "faturaTipi" => "SATIS",
                    "hangiTip" =>  "5000/30000",
                    "vknTckn" => $useridentity["uitaxno"],
                    "aliciUnvan" => $useridentity["uititle"],
                    "aliciAdi" => $useridentity["uititle"],
                    "aliciSoyadi" => "",
                    "binaAdi" => "",
                    "binaNo" => "",
                    "kapiNo" => "",
                    "kasabaKoy" => "",
                    "vergiDairesi" => $useridentity["uitaxadmin"],
                    "ulke" => $this->beGetCountryName($country["accode"]),
                    "bulvarcaddesokak" => $data["userinfo"]["uiaddress"],
                    "mahalleSemtIlce" => $province["apname"],
                    "sehir" => $distric["adname"],
                    "postaKodu" => "",
                    "tel" => $data["userinfo"]["uiphone"],
                    "fax" => "",
                    "eposta" => $data["user"]["email"],
                    "websitesi" => "",
                    "iadeTable" => [],
                    "ozelMatrahTutari" => "0",
                    "ozelMatrahOrani" => "0",
                    "ozelMatrahVergiTutari" => "0",
                    "vergiCesidi" => " ",
                    "malHizmetTable" => [],
                    "tip" => "İskonto",
                    "matrah" => $data["invoice"]["iprice"],
                    "malhizmetToplamTutari" => $data["invoice"]["iprice"],
                    "toplamIskonto" => "0",
                    "hesaplanankdv" => $data["invoice"]["itaxprice"],
                    "vergilerToplami" => $data["invoice"]["itaxprice"],
                    "vergilerDahilToplamTutar" => $data["invoice"]["iprice"]+$data["invoice"]["itaxprice"],
                    "odenecekTutar" => $data["invoice"]["iprice"]+$data["invoice"]["itaxprice"],
                    "not" => "",
                    "siparisNumarasi" => "",
                    "siparisTarihi" => "",
                    "irsaliyeNumarasi" => "",
                    "irsaliyeTarihi" => "",
                    "fisNo" => "",
                    "fisTarihi" => "",
                    "fisSaati" => "",
                    "fisTipi" => "",
                    "zRaporNo" => "",
                    "okcSeriNo" => ""
                ];
                break;
        }
        $types = [
            "none" => "C62",
            "day" => "DAY",
            "month" => "MON",
            "year" => "ANN",
            "quanity" => "C62"
        ];
        foreach($data["invoiceitems"] as $item){
            if($item["cid"] != $currency["cid"]){
                $item["iiunitprice"] = beConvertCurrencie($item["iiunitprice"],(int)$item["cid"],(int)$currency["cid"]);
            }
            $itemprice = $item["iiunitprice"]*$item["iiunitcount"];
            if(!$resettax){
                $itemtax = round($itemprice*$item["iitaxrate"]/100,2);
            }
            else{
                $itemtax = 0; 
                $item["iitaxrate"] = 0;
            }
            if(preg_match('/(.*)\((.*)\)/',$item["iiname"],$basketdata)){
                $requestdata["malHizmetTable"][] = [
                    "malHizmet" => $basketdata[1],
                    "miktar" => $item["iiunitcount"],
                    "birim" => $types[$item["iiunittype"]],
                    "birimFiyat" => $item["iiunitprice"],
                    "fiyat" => $itemprice,
                    "iskontoNedeni" => "İskonto",
                    "iskontoOrani" => 0,
                    "iskontoTutari" => "0",
                    "iskontoNedeni" => "",
                    "malHizmetTutari" => $itemprice+$itemtax,
                    "kdvOrani" => $item["iitaxrate"],
                    "kdvTutari" => $itemtax,
                    "vergininKdvTutari" => "0"
                ];
                $requestdata["not"] .= $basketdata[1].":".$basketdata[2]."\n";
            }
            else{
                $requestdata["malHizmetTable"][] = [
                    "malHizmet" => $item["iiname"],
                    "miktar" => $item["iiunitcount"],
                    "birim" => $types[$item["iiunittype"]],
                    "birimFiyat" => $item["iiunitprice"],
                    "fiyat" => $itemprice,
                    "iskontoNedeni" => "İskonto",
                    "iskontoOrani" => 0,
                    "iskontoTutari" => "0",
                    "iskontoNedeni" => "",
                    "malHizmetTutari" => $itemprice+$itemtax,
                    "kdvOrani" => $item["iitaxrate"],
                    "kdvTutari" => $itemtax,
                    "vergininKdvTutari" => "0"
                ];
            }
        }
        $response = $this->beSendRequest([
            "method" => "earsiv-services/dispatch",
            "data" => [
                "cmd" => "EARSIV_PORTAL_FATURA_OLUSTUR",
                "callid" => $this->beCreateGuid(BE_TIME),
                "pageName" => "RG_BASITFATURA",
                "token" => $token,
                "jp" => json_encode($requestdata)
            ]
        ]);
        if($response["data"] != "Faturanız başarıyla oluşturulmuştur. Düzenlenen Belgeler menüsünden faturanıza ulaşabilirsiniz."){
            if(!$notlogout){
                $this->gib_logout(["token" => $token]);
            }
            ModuleLogModel::beCreateModuleLog(0,"gib","Fatura Oluşturma Hatası","Fatura oluşturma esnasında bir sorun oluştu!",[
                "requestdata" => $requestdata,
                "response" => $response
            ]);
            return ["status" => false,"message" => "Fatura oluşturma esnasında bir sorun oluştu!"];
        }
        $response = $this->beSendRequest([
            "method" => "earsiv-services/dispatch",
            "data" => [
                "cmd" => "EARSIV_PORTAL_FATURA_GOSTER",
                "callid" => $this->beCreateGuid(BE_TIME),
                "pageName" => "RG_TASLAKLAR",
                "token" => $token,
                "jp" => json_encode([
                    "ettn" => $invoiceuuid,
                    "onayDurumu" => "Onaylandı"
                ],JSON_UNESCAPED_UNICODE)
            ]
        ]);
        if(!$notlogout){
            $this->gib_logout(["token" => $token]);
        }
        $filename = substr(md5(BE_TIME),0,8)."-".substr(md5($data["invoice"]["iid"]),0,8);
        $response["data"] = str_replace("<head>","<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />",$response["data"]);
        $upload = beUpload::beSetSpecialFile($filename,$response["data"],BE_APPPATH."resources/upload/invoice");
        if($upload["status"]){
            $slug = beSelfLink($upload["filename"]);
            $aid = AttachmentModel::beInsert([
                "uid" => $data["invoice"]["uid"],
                "aname" => $upload["filename"],
                "aslug" => $slug,
                "atype" => "text/html",
                "asize" => $upload["size"],
                "apath" => "resources/upload/invoice/".$upload["realname"],
                "aviews" => 0,
                "adownloads" => 0,
                "astatus" => "1",
                "afavorite" => "0",
                "apassword" => "",
                "adateline" => BE_TIME
            ]);
            return ["status" => true,"invoicedata" => [
                "ibilldata" => json_encode([
                    "aid" => $aid,
                    "uuid" => $invoiceuuid   
                ],JSON_UNESCAPED_UNICODE),
                "ibill" => 1
            ]];
        }
        else{
            return ["status" => true,"invoicedata" => [
                "ibilldata" => json_encode([
                    "uuid" => $invoiceuuid   
                ],JSON_UNESCAPED_UNICODE)
            ]];
        }
    }
    public function gib_get_company($data = []){
        $response = $this->beSendRequest([
            "method" => "earsiv-services/dispatch",
            "data" => [
                "cmd" => "SICIL_VEYA_MERNISTEN_BILGILERI_GETIR",
                "callid" => $this->beCreateGuid(BE_TIME),
                "pageName" => "RG_BASITFATURA",
                "token" => $data["token"],
                "jp" => json_encode([
                    "vknTcknn" => $data["taxno"],
                ],JSON_UNESCAPED_UNICODE)
            ]
        ]);
        if(!$response["data"]["unvan"]){
            return ["status" => false,"message" => "Bilgiler çekilirken bir sorun oluştu"];
        }
        return [
            "status" => true,
            "company_name" => $response["data"]["unvan"],
            "name" => $response["data"]["adi"],
            "surname" => $response["data"]["soyadi"],
            "taxoffice" => $response["data"]["vergiDairesi"]
        ];
    }
    public function gib_get_invoice($data = []){
        $requestdata = [
            "token" => $data["token"],
            "session" => $data["session"],
            "company" => "",
            "guid" => $data["guid"]
        ];
        $response = $this->beSendRequest([
            "method" => "getinvoicepdf",
            "data" => $requestdata
        ]);
        if(!$response["status"]){
            return ["status" => false,"message" => "Fatura çekilirken bir sorun oluştu"];
        }
        return ["status" => true,"pdf_data" => base64_decode($response["data"])];
    }
    public function beCreateGuid($nodekey = 0) {
        $beTimeStep = (int)(microtime(true)*10000000)+mt_rand(0,9)+0x01b21dd213814000;
        $beNode = substr(md5($nodekey),0,12);
        $beNode[0] = dechex(hexdec($beNode[0]) & 1);
        $beClockSeq = mt_rand(0,0x3FFF);
        $beTimeAlt = $beTimeStep & 0xFFFFFFFF;
        $beTimeUp = ($beTimeStep >> 32) & 0xFFFF;
        $beTimeVer = ($beTimeStep >> 48) & 0x0FFF;
        $beTimeVer |= (1 << 12);
        $beRevClockSeq = ($beClockSeq & 0x3F00) >> 8;
        $beRevClockSeq |= 0x80;
        $beClockSeqAlt = $beClockSeq & 0xFF;
        return sprintf("%08x-%04x-%04x-%02x%02x-%s", $beTimeAlt, $beTimeUp, $beTimeVer, $beRevClockSeq, $beClockSeqAlt, $beNode);
    }
    public function beSendRequest($data = []){
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,"https://earsivportal.efatura.gov.tr/{$data["method"]}");
        curl_setopt($ch,CURLOPT_POST,1);
        curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query($data["data"]));
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch,CURLOPT_TIMEOUT,10);
        curl_setopt($ch,CURLOPT_USERAGENT,"Mozilla/5.0 (Windows NT 6.2; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0");
        curl_setopt($ch,CURLOPT_IPRESOLVE,CURL_IPRESOLVE_V4);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        $response = curl_exec($ch);
        curl_close($ch);
        return json_decode($response,true);
    }
    public function beGetCountryName($code){
        $countrylist = [
            "TR" => "Türkiye",
            "AF" => "Afganistan",
            "DE" => "Almanya",
            "US" => "Amerika Birleşik Dev",
            "US_SAMOASI" => "Amerika Samoasi",
            "AD" => "Andorra",
            "AO" => "Angola",
            "AI" => "Anguilla",
            "AQ" => "Antartika",
            "AG" => "Antigua Ve Bermuda",
            "AR" => "Arjantin",
            "AL" => "Arnavutluk",
            "AW" => "Aruba",
            "AU" => "Avustralya",
            "AT" => "Avusturya",
            "AZ" => "Azerbeycan-Nahçivan",
            "BS" => "Bahamalar",
            "BH" => "Bahreyn",
            "BD" => "Bangladeş",
            "BB" => "Barbados",
            "BE" => "Belçika",
            "BZ" => "Belize",
            "BJ" => "Benin",
            "BM" => "Bermuda",
            "BY" => "Beyaz Rusya",
            "BT" => "Bhutan",
            "BO" => "Bolivya",
            "BA" => "Bosna-Hersek",
            "BW" => "Bostvana",
            "BV" => "Bouvet Adası",
            "BR" => "Brezilya",
            "BN" => "Brunei",
            "BG" => "Bulgaristan",
            "BF" => "Burkina Faso",
            "BI" => "Burundi",
            "AE" => "Birleşik Arap Emirli",
            "UM" => "Birleşik Devletler M",
            "GB" => "Birleşik Krallik",
            "CV" => "Cape Verde",
            "KY" => "Cayman Adaları",
            "EA" => "Ceuta Ve Melilla",
            "DZ" => "Cezayir",
            "CX" => "Christmas Adaları",
            "CC" => "Cook Adaları",
            "DJ" => "Cibuti",
            "TD" => "Çad",
            "CZ" => "Çek Cumhuriyeti",
            "CN" => "Çin Halk Cumhuriyeti",
            "DK" => "Danimarka",
            "DO" => "Dominik Cumhuriyeti",
            "DM" => "Dominika",
            "TL" => "Doğu Timor",
            "EC" => "Ekvator",
            "GQ" => "Ekvator Ginesi",
            "SV" => "El Salvador",
            "ID" => "Endonezya",
            "AM" => "Ermenistan",
            "ER" => "Eritre",
            "EE" => "Estonya",
            "ET" => "Etiyopya",
            "FK" => "Falkland Adaları",
            "FO" => "Faroe Adaları",
            "MA" => "Fas",
            "FR" => "Fransa",
            "GF" => "Fransiz Guyanasi",
            "TF" => "Fransiz Güney Toprak",
            "PF" => "Fransiz Polinezyasi",
            "FJ" => "Fiji",
            "CI" => "Fildişi Sahili",
            "PH" => "Filipinler",
            "PS" => "Filistin",
            "FI" => "Finlandiya",
            "GA" => "Gabon",
            "GM" => "Gambiya",
            "GH" => "Gana",
            "GD" => "Grenada",
            "GL" => "Grönland",
            "GP" => "Guadelup",
            "GU" => "Guam",
            "GT" => "Guatemala",
            "GY" => "Guyana",
            "ZA" => "Güney Afrika Cumhuri",
            "GS" => "Güney Georgia Ve Gün",
            "KR" => "Güney Kore Cumhuriye",
            "GE" => "Gürcistan",
            "GN" => "Gine",
            "GW" => "Gine-Bissau",
            "HT" => "Haiti",
            "HM" => "Heard Adaları Ve Mc",
            "HR" => "Hirvatistan",
            "NL" => "Hollanda",
            "AN" => "Hollanda Antilleri",
            "BQ" => "Hollanda Antilleri",
            "HN" => "Honduras",
            "HK" => "Hong Kong",
            "IN" => "Hindistan",
            "IQ" => "Irak",
            "VG" => "İngiliz Virgin Adala",
            "IR" => "İran",
            "IE" => "İrlanda",
            "ES" => "İspanya",
            "IL" => "İsrail",
            "SE" => "İsveç",
            "CH" => "İsviçre",
            "IT" => "İtalya",
            "IS" => "İzlanda",
            "JM" => "Jamaika",
            "JP" => "Japonya",
            "KH" => "Kamboçya",
            "CM" => "Kamerun",
            "CA" => "Kanada",
            "ME" => "Karadağ",
            "QA" => "Katar",
            "KZ" => "Kazakistan",
            "KE" => "Kenya",
            "KG" => "Kirgizistan",
            "CC" => "Kokos Adaları",
            "CO" => "Kolombiya",
            "KM" => "Komoro Adaları",
            "CD" => "Kongo",
            "XK" => "Kosova",
            "CR" => "Kosta Rika",
            "KW" => "Kuveyt",
            "CY" => "Kuzey Kibris Türk Cu",
            "KP" => "Kuzey Kore Demokrati",
            "MP" => "Kuzey Mariana Adalar",
            "CG" => "Kongo (Demokratik Cu)",
            "CU" => "Küba",
            "KI" => "Kiribati",
            "LA" => "Laos",
            "LS" => "Lesotho",
            "LV" => "Letonya",
            "LI" => "Lieshtenstein",
            "LB" => "Lübnan",
            "LU" => "Lüksemburg",
            "LR" => "Liberya",
            "LY" => "Libya",
            "LT" => "Litvanya",
            "HU" => "Macaristan",
            "MG" => "Madagaskar",
            "MO" => "Makao",
            "MK" => "Makedonya",
            "MW" => "Malavi",
            "MV" => "Maldiv Adaları",
            "MY" => "Malezya",
            "MT" => "Malta",
            "ML" => "Mali",
            "MH" => "Marshall Adaları",
            "MQ" => "Martinik",
            "MU" => "Mauritius",
            "YT" => "Mayotte",
            "MX" => "Meksika",
            "EG" => "Misir",
            "MD" => "Moldavya",
            "MC" => "Monaco",
            "MS" => "Montserrat",
            "MR" => "Moritanya",
            "MZ" => "Mozambik",
            "MN" => "Moğolistan",
            "MM" => "Myanmar",
            "FM" => "Mikronezya",
            "NA" => "Namibya",
            "NR" => "Nauru",
            "NP" => "Nepal",
            "NF" => "Norfolk Adası",
            "NO" => "Norveç",
            "NE" => "Nijer",
            "NG" => "Nijerya",
            "NI" => "Nikaragua",
            "NU" => "Niue",
            "CF" => "Orta Afrika Cumhuriy",
            "UZ" => "Özbekistan",
            "PK" => "Pakistan",
            "PW" => "Palau",
            "PA" => "Panama",
            "PG" => "Papua Yeni Gine",
            "PY" => "Paraguay",
            "PE" => "Peru",
            "PL" => "Polonya",
            "PT" => "Portekiz",
            "PN" => "Pitcairn",
            "RE" => "Reunion",
            "RO" => "Romanya",
            "RW" => "Ruanda",
            "RU" => "Rusya Federasyonu",
            "SM" => "San Marino",
            "ST" => "Sao Tome And Princip",
            "SN" => "Senegal",
            "SC" => "Seyşel Adaları Ve Ba",
            "SL" => "Sierra Leone",
            "RS" => "Sirbistan",
            "SK" => "Slovakya",
            "SI" => "Slovenya",
            "SB" => "Solomon Adaları",
            "SO" => "Somali",
            "LK" => "Sri Lanka",
            "VC" => "St Vincent Ve Grenad",
            "SH" => "St. Helena Ve Bağlan",
            "KN" => "St. Kitts Ve Nevis",
            "LC" => "St. Lucia",
            "PM" => "St. Pierre Ve Miquel",
            "SD" => "Sudan",
            "SR" => "Surinam",
            "SY" => "Suriye",
            "SA" => "Suudi Arabistan",
            "SZ" => "Svaziland",
            "WS" => "Samoa (Batı Samoa)",
            "ZZ" => "Serbest Bölge (Ba-Bs)",
            "SG" => "Singapur",
            "CL" => "Şili",
            "TJ" => "Tacikistan",
            "TH" => "Tayland",
            "TW" => "Tayvan",
            "TG" => "Togo",
            "TK" => "Tokelau",
            "TO" => "Tonga",
            "TT" => "Trinidad Ve Tobago",
            "TN" => "Tunus",
            "TC" => "Turks Ve Caicos Adas",
            "TV" => "Tuvalu",
            "TZ" => "Tanzanya (Birleşik C)",
            "TM" => "Türkmenistan",
            "UG" => "Uganda",
            "UA" => "Ukrayna",
            "OM" => "Umman",
            "UY" => "Uruguay",
            "JO" => "Ürdün",
            "VU" => "Vanuatu",
            "VA" => "Vatikan",
            "VE" => "Venezuella",
            "VN" => "Vietnam",
            "WF" => "Wallis Ve Futuna Ada",
            "YE" => "Yemen",
            "NC" => "Yeni Kalodenya Ve Ba",
            "NZ" => "Yeni Zelanda",
            "YU" => "Yugoslavya(Eski Yugo)",
            "CS" => "Yugoslavya(Sirbistan)",
            "GR" => "Yunanistan",
            "ZM" => "Zambia",
            "ZW" => "Zimbabve"
        ];
        return $countrylist[$code];
    }
}
?>