<style>
    .infoboxex {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    .infobox {
        padding: 10px 14px;
        border-radius: 10px;
        box-shadow: 0 0 5px #e3e3e3;
        background-color: #ffff;
    }
    .infobox .name {
        margin-bottom: 14px;
        font-size: 16px;
    }
    .infobox i {
        margin-right: 4px;
    } 
    .infobox .value {
        font-size: 18px;
    }
    .accounting .finance {
        font-size: 32px;
    }
    .accounting .nextdue {
        font-size: 12px;
    }
    .besr_circle_chart {
        display: block;
        margin: 10px auto;
        max-height: 140px;
    }
    .besr_circle_bg {
        fill: none;
        stroke: #eee;
        stroke-width: 3.8;
    }
    .besr_circle {
        fill: none;
        stroke-width: 2.8;
        stroke-linecap: round;
        animation: progress 1s ease-out forwards;
    }
    @keyframes progress {
        0% {
            stroke-dasharray: 0 100;
        }
    }
    .besr_circle_percentage {
        fill: #59626d;
        font-size: 7px;
        text-anchor: middle;
    }
</style>
<div class="row">
    <div class="col-8 col-md-12">
        <div class="row">
            <div class="col-12 col-md-12 mb-3">
                <div class="card accounting">
                    <div class="card-header">
                        <div>
                            <span class="card-title"><i class="ri-bank-line"></i> Muhasebe</span>
                        </div>
                    </div>
                    <div class="card-content">
                        <div class="row my-3">
                            <div class="col-12">
                                <span class="finance text-success"><?= beMoneyFormat($orderinfo['amount']).' '.$orderinfo['currencie']['cicon'] ?></span>
                            </div>
                            <div class="col-6 nextdue">
                                <span>Sonraki Ödeme Tarihi</span>
                                <span><?= $orderinfo['nextduedate'] ?></span>
                            </div>
                        </div>
                        <hr>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span><?= __('domainnameapi_info_productname') ?></span>
                            </div>
                            <div class="col-6">
                                <span><?= $orderinfo['product'] ?></span>
                            </div>
                        </div>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span><?= __('domainnameapi_info_buydate') ?></span>
                            </div>
                            <div class="col-6">
                                <span><?= $orderinfo['regdate'] ?></span>
                            </div>
                        </div>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span><?= __('domainnameapi_info_basicprice') ?></span>
                            </div>
                            <div class="col-6">
                                <span><?= beMoneyFormat($orderinfo['amount']).' '.$orderinfo['currencie']['cicon'] ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-4 col-md-12">
        <div class="card accounting">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-user-line"></i> Giriş Bilgileri</span>
                </div>
            </div>
            <div class="card-content">
                <div class="row mt-1">
                    <div class="col-12">
                        <span><?= __('domainnameapi_info_domain') ?>:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span><?= $domain ?><a href="#" class="beCopyText text-sm text-normal ml-1" title="Kopyala" data-content="<?= $domain ?>"><i class="ri-clipboard-line"></i></a></span>
                    </div>
                </div>
                <div class="text-center my-3">
                    <span class="text-xsm">Lütfen transfer kodlarını vb. bilgileri siz haricinde kimse ile paylaşmayınız! Sonuçlardan doğacak yükümlülüklerden <?= beGetConfig('sitename') ?> sorumlu değildir!</span>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid=<?= $userproduct['upid'] ?>";
            }
            else{
                datacontent = data+"&action="+method+"&upid=<?= $userproduct['upid'] ?>";
            }
            $.ajax({
                url: "<?= beGetRoute('client.userproduct.userproduct.show.post') ?>",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
</script>