<style>
    .infoboxex {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    .infobox {
        padding: 10px 14px;
        border-radius: 10px;
        box-shadow: 0 0 5px #e3e3e3;
        background-color: #ffff;
    }
    .infobox .name {
        margin-bottom: 14px;
        font-size: 16px;
    }
    .infobox i {
        margin-right: 4px;
    } 
    .infobox .value {
        font-size: 18px;
    }
    .accounting .finance {
        font-size: 32px;
    }
    .accounting .nextdue {
        font-size: 12px;
    }
    .accounting .infoname {
        border-bottom: 1px solid #151b2c;
    }
    .besr_circle_chart {
        display: block;
        margin: 10px auto;
        max-height: 140px;
    }
    .besr_circle_bg {
        fill: none;
        stroke: #eee;
        stroke-width: 3.8;
    }
    .besr_circle {
        fill: none;
        stroke-width: 2.8;
        stroke-linecap: round;
        animation: progress 1s ease-out forwards;
    }
    @keyframes progress {
        0% {
            stroke-dasharray: 0 100;
        }
    }
    .besr_circle_percentage {
        fill: #59626d;
        font-size: 7px;
        text-anchor: middle;
    }
</style>
<div class="row">
    <div class="col-8 col-md-12">
        <div class="row">
            <div class="col-12">
                <div class="card accounting">
                    <div class="card-header">
                        <div>
                            <span class="card-title"><i class="ri-bank-line"></i> Muhasebe</span>
                        </div>
                    </div>
                    <div class="card-content">
                        <div class="row my-3">
                            <div class="col-6">
                                <span class="finance text-success"><?= beMoneyFormat($orderinfo['amount']).' '.$orderinfo['currencie']['cicon'] ?></span>
                            </div>
                            <div class="col-6 nextdue">
                                <span>Sonraki Ödeme Tarihi</span>
                                <span><?= $orderinfo['nextduedate'] ?></span>
                            </div>
                        </div>
                        <hr>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span><?= __('server_info_productname') ?></span>
                            </div>
                            <div class="col-6">
                                <span><?= $orderinfo['product'] ?></span>
                            </div>
                        </div>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span><?= __('server_info_buydate') ?></span>
                            </div>
                            <div class="col-6">
                                <span><?= $orderinfo['regdate'] ?></span>
                            </div>
                        </div>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span><?= __('server_info_basicprice') ?></span>
                            </div>
                            <div class="col-6">
                                <span><?= beMoneyFormat($orderinfo['billingprice']).' '.$orderinfo['currencie']['cicon'] ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 mt-3">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <span class="card-title"><i class="ri-line-chart-line"></i> Kullanım Bilgileri</span>
                        </div>
                    </div>
                    <div class="card-content">
                        <div class="row row-center mb-3">
                            <div class="col-3">
                                <div class="text-center"><?= __('stats_inode') ?></div>
                                <div class="besr_percent">
                                    <svg viewBox="0 0 36 36" class="besr_circle_chart">
                                        <path class="besr_circle_bg" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831"/>
                                        <path class="besr_circle" stroke-dasharray="<?= $usageinfo['inode_percent'] ?>, 100" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" style="stroke: <?= $usageinfo['cpu_percent_color'] ?>"/>
                                        <text class="besr_circle_percentage" x="18" y="20.35"><?= $usageinfo['inode_percent'] ?>%</text>
                                    </svg>
                                </div>
                                <div class="text-center text-normal text-sm" id="cpuPercentText"><?= $usageinfo['inode_usage'] ?> / <?= $usageinfo['inode_max'] ?></div>
                            </div>
                            <div class="col-3">
                                <div class="text-center"><?= __('stats_disk') ?></div>
                                <div class="besr_percent">
                                    <svg viewBox="0 0 36 36" class="besr_circle_chart">
                                        <path class="besr_circle_bg" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831"/>
                                        <path class="besr_circle" stroke-dasharray="<?= $usageinfo['disk_percent'] ?>, 100" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" style="stroke: <?= $usageinfo['ram_percent_color'] ?>"/>
                                        <text class="besr_circle_percentage" x="18" y="20.35"><?= $usageinfo['disk_percent'] ?>%</text>
                                    </svg>
                                </div>
                                <div class="text-center text-normal text-sm"><?= $usageinfo['disk_usage'] ?> MB / <?= $usageinfo['disk_max'] ?> MB</div>
                            </div>
                        </div>
                        <div class="row row-end">
                            <span class="text-xsm">Veriler anlık güncellenmektedir son güncellenme <?= beSpecialTime(BE_TIME,' H:i:s') ?></span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 mt-3 mb-3">
                <div class="card accounting">
                    <div class="card-header">
                        <div>
                            <span class="card-title"><i class="ri-home-office-line"></i> Hızlı Giriş</span>
                        </div>
                    </div>
                    <div class="card-content">
                        <div class="row">
                            <div class="col-4 col-md-12 row-stack mb-3">
                                <a href="#" class="btn btn-transparent btn-column beCallRequestx w-100" data-method="login_session" data-data="application=Email_Accounts"><i class="ri-mail-line"></i> Email Hesapları</a>
                            </div>
                            <div class="col-4 col-md-12 row-stack mb-3">
                                <a href="#" class="btn btn-transparent btn-column beCallRequestx w-100" data-method="login_session" data-data="application=Email_Forwarders"><i class="ri-mail-settings-line"></i> Email Yönlendiricisi</a>
                            </div>
                            <div class="col-4 col-md-12 row-stack mb-3">
                                <a href="#" class="btn btn-transparent btn-column beCallRequestx w-100" data-method="login_session" data-data="application=Email_AutoResponders"><i class="ri-reply-all-line"></i> Otomatik Mail</a>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-4 col-md-12 row-stack mb-3">
                                <a href="#" class="btn btn-transparent btn-column beCallRequestx w-100" data-method="login_session" data-data="application=FileManager_Home"><i class="ri-folders-fill"></i> Dosya Yöneticisi</a>
                            </div>
                            <div class="col-4 col-md-12 row-stack mb-3">
                                <a href="#" class="btn btn-transparent btn-column beCallRequestx w-100" data-method="login_session" data-data="application=Backups_Home"><i class="ri-folder-chart-line"></i> Yedekleme</a>
                            </div>
                            <div class="col-4 col-md-12 row-stack mb-3">
                                <a href="#" class="btn btn-transparent btn-column beCallRequestx w-100" data-method="login_session" data-data="application=Cron_Home"><i class="ri-alarm-line"></i> Görevler</a>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-6 col-md-12 row-stack mb-3">
                                <a href="#" class="btn btn-transparent btn-column beCallRequestx w-100" data-method="login_session" data-data="application=Domains_AddonDomains"><i class="ri-global-line"></i> Eklenti Domain</a>
                            </div>
                            <div class="col-6 col-md-12 row-stack mb-3">
                                <a href="#" class="btn btn-transparent btn-column beCallRequestx w-100" data-method="login_session" data-data="application=Domains_SubDomains"><i class="ri-earth-line"></i> Alt Domain</a>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-6 col-md-12 row-stack mb-3">
                                <a href="#" class="btn btn-transparent btn-column beCallRequestx w-100" data-method="login_session" data-data="application=Database_MySQL"><i class="ri-database-line"></i> MySQL Veritabanları</a>
                            </div>
                            <div class="col-6 col-md-12 row-stack mb-3">
                                <a href="#" class="btn btn-transparent btn-column beCallRequestx w-100" data-method="login_session" data-data="application=Database_phpMyAdmin"><i class="ri-database-2-line"></i> phpMyAdmin</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-4 col-md-12">
        <div class="card accounting">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-user-line"></i> Giriş Bilgileri</span>
                </div>
            </div>
            <div class="card-content">
                <div class="row mt-1">
                    <div class="col-12">
                        <span class="infoname"><?= __('server_info_user') ?>:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span><?= $updata['username'] ?><a href="#" class="beCopyText text-sm text-normal ml-1" title="Kopyala" data-content="<?= $updata['username'] ?>"><i class="ri-clipboard-line"></i></a></span>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <span class="infoname"><?= __('server_info_password') ?>:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span><?= $updata['password'] ?><a href="#" class="beCopyText text-sm text-normal ml-1" title="Kopyala" data-content="<?= $updata['password'] ?>"><i class="ri-clipboard-line"></i></a></span>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <span class="infoname"><?= __('server_info_ipaddress') ?>:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span><?= $server['surl'] ?><a href="#" class="beCopyText text-sm text-normal ml-1" title="Kopyala" data-content="<?= $server['surl'] ?>"><i class="ri-clipboard-line"></i></a></span>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <span class="infoname">Nameserver1:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span><?= $server['snameserver1'] ?><a href="#" class="beCopyText text-sm text-normal ml-1" title="Kopyala" data-content="<?= $server['snameserver1'] ?>"><i class="ri-clipboard-line"></i></a></span>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <span class="infoname">Nameserver2:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span><?= $server['snameserver2'] ?><a href="#" class="beCopyText text-sm text-normal ml-1" title="Kopyala" data-content="<?= $server['snameserver2'] ?>"><i class="ri-clipboard-line"></i></a></span>
                    </div>
                </div>
                <hr>
                <div class="row mt-3">
                    <?php if($loginlinks['whostmgrd']): ?>
                    <div class="col-12 row-stack mb-3">
                        <a href="<?= $loginlinks['whostmgrd'] ?>" target="_blank" class="btn btn-transparent"><i class="ri-login-box-line"></i> WHM'e Giriş Yap</a>
                    </div>
                    <?php endif; ?>
                    <div class="col-12 row-stack mb-3">
                        <a href="<?= $loginlinks['cpanel'] ?>" target="_blank" class="btn btn-primary"><i class="ri-login-box-line"></i> cPanel'e Giriş Yap</a>
                    </div>
                    <div class="col-12 row-stack mb-3">
                        <a href="<?= $loginlinks['webmail'] ?>" target="_blank" class="btn btn-success"><i class="ri-mail-send-line"></i> webMail'e Giriş Yap</a>
                    </div>
                </div>
                <div class="text-center my-3">
                    <span class="text-xsm">Lütfen giriş bilgilerinizi hiç bir şahıs,firma ile paylaşmayınız! Sonuçlardan doğacak yükümlülüklerden <?= beGetConfig('sitename') ?> sorumlu değildir!</span>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid=<?= $userproduct['upid'] ?>";
            }
            else{
                datacontent = data+"&action="+method+"&upid=<?= $userproduct['upid'] ?>";
            }
            $.ajax({
                url: "<?= beGetRoute('client.userproduct.userproduct.show.post') ?>",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                        if(response.url){
                            setTimeout(function(){
                                window.location.href = response.url;
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
</script>