<!DOCTYPE html>
<html xml:lang="tr" lang="tr" xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title>Hizmetlerim - <?= beGetConfig('sitename') ?></title>
        <?= $headerinclude ?>
        <link href="assets/servertize/css/clientarea.css?ver=24" rel="stylesheet">
        <link href="assets/servertize/css/card.css?ver=30" rel="stylesheet">
        <link href="assets/servertize/css/col.css?ver=42" rel="stylesheet">
        <link href="assets/servertize/css/forms.css?ver=21" rel="stylesheet">
        <style>
.beSetMethod.selected {
    border: 2px solid #009ef7;
}
</style>
    </head>
    <body>
        <main>
            <?= $header ?>
            <div class="content">
                <div class="container bclientarea">
                    <div class="col-3 col-md-12">
                        <div class="bmenu">
                            <div class="bmenu-header">
                                <span>Müşteri Paneli</span>
                            </div>
                            <div class="bmenu-content">
                                <ul>
                                    <li data-page="client.dashboard.alternative">
                                        <a href="<?= beGetRoute('client.dashboard.alternative') ?>">
                                            <div>
                                                <i class="ri-service-line"></i>
                                                <span>Ana Sayfa</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li data-page="client.userproduct.userproducts">
                                        <a href="<?= beGetRoute('client.userproduct.userproducts') ?>">
                                            <div>
                                                <i class="ri-shopping-cart-line"></i>
                                                <span>Hizmetlerim</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="#" class="bmenu-altmenu-button" id="clientarea-invoicemenu">
                                            <div>
                                                <i class="ri-git-repository-line"></i>
                                                <span>Muhasebe</span>
                                            </div>
                                            <div>
                                                <i class="ri-arrow-down-s-line"></i>
                                            </div>
                                        </a>
                                        <div class="bmenu-altmenu">
                                            <ul>
                                                <li class="has-mainmenu" data-page="client.invoice.invoices" data-mainmenu="clientarea-invoicemenu">
                                                    <a href="<?= beGetRoute('client.invoice.invoices') ?>">
                                                        <div>
                                                            <i class="ri-asterisk"></i>
                                                            <span>Tüm Faturalarım</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.invoice.invoices.paid" data-mainmenu="clientarea-invoicemenu">
                                                    <a href="<?= beGetRoute('client.invoice.invoices.paid') ?>">
                                                        <div>
                                                            <i class="ri-cloud-line"></i>
                                                            <span>Ödenmiş Faturalarım</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.invoice.invoices.unpaid" data-mainmenu="clientarea-invoicemenu">
                                                    <a href="<?= beGetRoute('client.invoice.invoices.unpaid') ?>">
                                                        <div>
                                                            <i class="ri-cloud-off-line"></i>
                                                            <span>Ödenmemiş Faturalarım</span>
                                                        </div>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                    <li>
                                        <a href="#" class="bmenu-altmenu-button" id="clientarea-ticketmenu">
                                            <div>
                                                <i class="ri-coupon-line"></i>
                                                <span>Destek</span>
                                            </div>
                                            <div>
                                                <i class="ri-arrow-down-s-line"></i>
                                            </div>
                                        </a>
                                        <div class="bmenu-altmenu">
                                            <ul>
                                                <li class="has-mainmenu" data-page="client.ticket.tickets" data-mainmenu="clientarea-ticketmenu">
                                                    <a href="<?= beGetRoute('client.ticket.tickets') ?>">
                                                        <div>
                                                            <i class="ri-ticket-line"></i>
                                                            <span>Destek Taleplerim</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.ticket.newticket" data-mainmenu="clientarea-ticketmenu">
                                                    <a href="<?= beGetRoute('client.ticket.newticket') ?>">
                                                        <div>
                                                            <i class="ri-coupon-3-line"></i>
                                                            <span>Yeni Destek Talebi</span>
                                                        </div>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                    <li>
                                        <a href="#" class="bmenu-altmenu-button" id="clientarea-settingsmenu">
                                            <div>
                                                <i class="ri-settings-2-line"></i>
                                                <span>Ayarlar</span>
                                            </div>
                                            <div>
                                                <i class="ri-arrow-down-s-line"></i>
                                            </div>
                                        </a>
                                        <div class="bmenu-altmenu">
                                            <ul>
                                                <li class="has-mainmenu" data-page="client.userinfo" data-mainmenu="clientarea-settingsmenu">
                                                    <a href="<?= beGetRoute('client.userinfo') ?>">
                                                        <div>
                                                            <i class="ri-user-line"></i>
                                                            <span>Kullanıcı Bilgileri</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.settings" data-mainmenu="clientarea-settingsmenu">
                                                    <a href="<?= beGetRoute('client.settings') ?>">
                                                        <div>
                                                            <i class="ri-user-line"></i>
                                                            <span>Kullanıcı Ayarları</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.systemsettings" data-mainmenu="clientarea-settingsmenu">
                                                    <a href="<?= beGetRoute('client.systemsettings') ?>">
                                                        <div>
                                                            <i class="ri-notification-badge-line"></i>
                                                            <span>Sistem Ayarları</span>
                                                        </div>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                    <li>
                                        <a href="#" class="bmenu-altmenu-button" id="clientarea-logmenu">
                                            <div>
                                                <i class="ri-history-line"></i>
                                                <span>Kayıtlar</span>
                                            </div>
                                            <div>
                                                <i class="ri-arrow-down-s-line"></i>
                                            </div>
                                        </a>
                                        <div class="bmenu-altmenu">
                                            <ul>
                                                <li class="has-mainmenu" data-page="client.log.alert" data-mainmenu="clientarea-logmenu">
                                                    <a href="<?= beGetRoute('client.log.alert') ?>">
                                                        <div>
                                                        <i class="ri-notification-line"></i>
                                                            <span>Bildirim Kayitlari</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.log.sms" data-mainmenu="clientarea-logmenu">
                                                    <a href="<?= beGetRoute('client.log.sms') ?>">
                                                        <div>
                                                            <i class="ri-phone-line"></i>
                                                            <span>SMS Kayıtları</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.log.email" data-mainmenu="clientarea-logmenu">
                                                    <a href="<?= beGetRoute('client.log.email') ?>">
                                                        <div>
                                                            <i class="ri-mail-send-line"></i>
                                                            <span>Mail Kayıtları</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.log.user" data-mainmenu="clientarea-logmenu">
                                                    <a href="<?= beGetRoute('client.log.user') ?>">
                                                        <div>
                                                            <i class="ri-user-location-line"></i>
                                                            <span>Kullanıcı Kayıtları</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.log.product" data-mainmenu="clientarea-logmenu">
                                                    <a href="<?= beGetRoute('client.log.product') ?>">
                                                        <div>
                                                            <i class="ri-shopping-cart-line"></i>
                                                            <span>Geçmiş Hizmet Kayıtları</span>
                                                        </div>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                    <li data-page="client.announcement">
                                        <a href="<?= beGetRoute('client.announcement') ?>">
                                            <div>
                                                <i class="ri-medal-2-line"></i>
                                                <span>Duyurular</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li data-page="client.banks">
                                        <a href="<?= beGetRoute('client.banks') ?>">
                                            <div>
                                            <i class="ri-bank-line"></i>
                                                <span>Banka Hesaplarımız</span>
                                            </div>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="bmenu">
                            <div class="bmenu-header">
                                <span>Hızlı Erişim</span>
                            </div>
                            <div class="bmenu-content">
                                <ul>
                                    <li>
                                        <a href="<?= beGetRoute('client.ticket.newticket') ?>">
                                            <div>
                                                <i class="ri-coupon-3-line"></i>
                                                <span>Destek Talebi Oluştur</span>
                                            </div>
                                        </a>
                                    </li>
                                    <?php if($be->settings['system_localmoney'] == 1): ?>
                                    <li>
                                        <a href="<?= beGetRoute('client.invoice.money') ?>">
                                            <div>
                                                <i class="ri-wallet-2-line"></i>
                                                <span>Kredi Yükleme</span>
                                            </div>
                                        </a>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-9 col-md-12">
                        <div class="bcontent">
                            <div class="card mb-4">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-shopping-cart-line"></i> Hizmetlerim</span>
        </div>
    </div>
    <div class="card-content">
        <table class="btable">
            <thead>
                <tr>
                    <th>Hizmet No</th>
                    <th>Hizmet</th>
                    <th>Ücret</th>
                    <th>Sonraki Ödeme Tarihi</th>
                    <th>Durum</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php if($userproducts): ?>
                <?php foreach($userproducts as $userproduct): ?>
                <tr>
                    <td>
                        <input class="form-check-input checkExtend" type="checkbox" data-upid="1">
                        <span>#<?= $userproduct['upid'] ?></span>
                        <span class="beShowExtra text-primary" data-upid="<?= $userproduct['upid'] ?>"><i class="ri-arrow-down-double-fill"></i></span>
                    </td>
                    <td>
                        <div>
                            <span class="first-row"><?= $userproduct['upname'] ?></span>
                            <span class="second-row text-sm"><?= $userproduct['uptag'] ?></span>
                        </div>
                    </td>
                    <td>
                        <span class="first-row"><?= beMoneyFormat($userproduct['upprice']).' '.$currencies[$userproduct['cid']]['cicon'] ?></span>
                    </td>
                    <td>
                        <span class="first-row"><?= $userproduct['enddate'] ?></span>
                        <span class="second-row <?= $userproduct['endclass'] ?>"><?= $userproduct['endtext'] ?></span>
                    </td>
                    <td>
                        <span class="btn btn-<?= $userproductstatus[$userproduct['upstatus']][1] ?>">
                            <?= $userproductstatus[$userproduct['upstatus']][0] ?>
                        </span>
                    </td>
                    <td>
                        <div class="buttons">
                            <a href="#" class="btn btn-primary beCallRequest" data-url="<?= beGetRoute('client.userproduct.process') ?>" data-data="action=manage&upid=<?= $userproduct['upid'] ?>">
                                <i class="ri-terminal-box-line"></i>
                                Yönet
                            </a>
                            <?php if($userproduct['pextend'] == '1'): ?>
                                <a href="#" class="btn btn-warning beCallRequest ml-2" data-url="<?= beGetRoute('client.userproduct.process') ?>" data-data="action=extend&upid=<?= $userproduct['upid'] ?>">
                                    <i class="ri-timer-flash-line"></i>
                                    Uzat
                                </a>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <tr class="no-border row-none beExtraOptions<?= $userproduct['upid'] ?>">
                    <td colspan="6">
                        <form id="beExtraOptions<?= $userproduct['upid'] ?>Form">
                            <input type="hidden" name="upid" value="<?= $userproduct['upid'] ?>">
                            <div class="row">
                                <?php if($userproduct['pextendauto'] == 1): ?>
                                <div class="col-12 mb-2">
                                    <div class="form-check form-check-custom form-check-solid">
                                        <input type="hidden" name="upextendauto" value="0">
                                        <input class="form-check-input beSetAutoPay" type="checkbox" value="1" name="upextendauto" data-upid="<?= $userproduct['upid'] ?>" id="upextendauto<?= $userproduct['upid'] ?>"<?= $userproduct['upextendauto'] == 1 ? ' checked':'' ?>>
                                        <label class="form-check-label" for="upextendauto<?= $userproduct['upid'] ?>">
                                            Bu ürünü bakiyem ile otomatik olarak uzat
                                        </label>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <div class="col-12 row-center row-flex">
                                    <a href="#" class="btn btn-special beCallRequest" data-form="beExtraOptions<?= $userproduct['upid'] ?>" data-url="<?= beGetRoute('client.userproduct.options') ?>">Kaydet</a>
                                </div>
                            </div>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php else: ?>
                <tr>
                    <td colspan="6">
                        <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <div class="card-info">
            <div>
                <span><b><?= $product_count ?></b> adet hizmetiniz bulunuyor!</span>
            </div>
        </div>
    </div>
</div>
                        </div>
                    </div>
                </div>
            </div>
            <script>
$(".beShowExtra").on("click",function(){
    var upid = $(this).data("upid");
    var item = $(".beExtraOptions"+upid);
    if(item.css("display") == "none"){
        $(this).html('<i class="ri-arrow-up-double-fill"></i>');
        item.show("slow");
    }
    else{
        $(this).html('<i class="ri-arrow-down-double-fill"></i>');
        item.hide();
    }
});
$(".beSetMethod").on("click",function(){
    $(".beSetMethod.selected").removeClass("selected");
    $(".beSetMethod").addClass("selected");
});
</script>
            <script>
                $(document).ready(function(){
                    var routename = "<?= beGetRouteName() ?>";
                    var item = $("li[data-page='"+routename+"']");
                    if(item.hasClass("has-mainmenu")){
                        $("#"+item.data("mainmenu")).trigger("click");
                    }
                    item.addClass("active");
                });
            </script>
            <?= $footer ?>
        </main>
    </body>
</html>