<!DOCTYPE html>
<html xml:lang="tr" lang="tr" xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title>Fatura #<?= $invoice['iid'] ?> - <?= beGetConfig('sitename') ?></title>
        <?= $headerinclude ?>
        <link href="assets/servertize/css/clientarea.css?ver=24" rel="stylesheet">
        <link href="assets/servertize/css/card.css?ver=30" rel="stylesheet">
        <link href="assets/servertize/css/col.css?ver=42" rel="stylesheet">
        <link href="assets/servertize/css/forms.css?ver=21" rel="stylesheet">
        <style>
.invoice-key {
    display: block;
    font-size: 18px;
    color: #464d51;
}
.invoice-val {
    display: block;
    font-size: 14px;
    color: #464d51;
}
</style>
    </head>
    <body>
        <main>
            <?= $header ?>
            <div class="content">
                <div class="container bclientarea">
                    <div class="col-3 col-md-12">
                        <div class="bmenu">
                            <div class="bmenu-header">
                                <span>Müşteri Paneli</span>
                            </div>
                            <div class="bmenu-content">
                                <ul>
                                    <li data-page="client.dashboard.alternative">
                                        <a href="<?= beGetRoute('client.dashboard.alternative') ?>">
                                            <div>
                                                <i class="ri-service-line"></i>
                                                <span>Ana Sayfa</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li data-page="client.userproduct.userproducts">
                                        <a href="<?= beGetRoute('client.userproduct.userproducts') ?>">
                                            <div>
                                                <i class="ri-shopping-cart-line"></i>
                                                <span>Hizmetlerim</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="#" class="bmenu-altmenu-button" id="clientarea-invoicemenu">
                                            <div>
                                                <i class="ri-git-repository-line"></i>
                                                <span>Muhasebe</span>
                                            </div>
                                            <div>
                                                <i class="ri-arrow-down-s-line"></i>
                                            </div>
                                        </a>
                                        <div class="bmenu-altmenu">
                                            <ul>
                                                <li class="has-mainmenu" data-page="client.invoice.invoices" data-mainmenu="clientarea-invoicemenu">
                                                    <a href="<?= beGetRoute('client.invoice.invoices') ?>">
                                                        <div>
                                                            <i class="ri-asterisk"></i>
                                                            <span>Tüm Faturalarım</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.invoice.invoices.paid" data-mainmenu="clientarea-invoicemenu">
                                                    <a href="<?= beGetRoute('client.invoice.invoices.paid') ?>">
                                                        <div>
                                                            <i class="ri-cloud-line"></i>
                                                            <span>Ödenmiş Faturalarım</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.invoice.invoices.unpaid" data-mainmenu="clientarea-invoicemenu">
                                                    <a href="<?= beGetRoute('client.invoice.invoices.unpaid') ?>">
                                                        <div>
                                                            <i class="ri-cloud-off-line"></i>
                                                            <span>Ödenmemiş Faturalarım</span>
                                                        </div>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                    <li>
                                        <a href="#" class="bmenu-altmenu-button" id="clientarea-ticketmenu">
                                            <div>
                                                <i class="ri-coupon-line"></i>
                                                <span>Destek</span>
                                            </div>
                                            <div>
                                                <i class="ri-arrow-down-s-line"></i>
                                            </div>
                                        </a>
                                        <div class="bmenu-altmenu">
                                            <ul>
                                                <li class="has-mainmenu" data-page="client.ticket.tickets" data-mainmenu="clientarea-ticketmenu">
                                                    <a href="<?= beGetRoute('client.ticket.tickets') ?>">
                                                        <div>
                                                            <i class="ri-ticket-line"></i>
                                                            <span>Destek Taleplerim</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.ticket.newticket" data-mainmenu="clientarea-ticketmenu">
                                                    <a href="<?= beGetRoute('client.ticket.newticket') ?>">
                                                        <div>
                                                            <i class="ri-coupon-3-line"></i>
                                                            <span>Yeni Destek Talebi</span>
                                                        </div>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                    <li>
                                        <a href="#" class="bmenu-altmenu-button" id="clientarea-settingsmenu">
                                            <div>
                                                <i class="ri-settings-2-line"></i>
                                                <span>Ayarlar</span>
                                            </div>
                                            <div>
                                                <i class="ri-arrow-down-s-line"></i>
                                            </div>
                                        </a>
                                        <div class="bmenu-altmenu">
                                            <ul>
                                                <li class="has-mainmenu" data-page="client.userinfo" data-mainmenu="clientarea-settingsmenu">
                                                    <a href="<?= beGetRoute('client.userinfo') ?>">
                                                        <div>
                                                            <i class="ri-user-line"></i>
                                                            <span>Kullanıcı Bilgileri</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.settings" data-mainmenu="clientarea-settingsmenu">
                                                    <a href="<?= beGetRoute('client.settings') ?>">
                                                        <div>
                                                            <i class="ri-user-line"></i>
                                                            <span>Kullanıcı Ayarları</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.systemsettings" data-mainmenu="clientarea-settingsmenu">
                                                    <a href="<?= beGetRoute('client.systemsettings') ?>">
                                                        <div>
                                                            <i class="ri-notification-badge-line"></i>
                                                            <span>Sistem Ayarları</span>
                                                        </div>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                    <li>
                                        <a href="#" class="bmenu-altmenu-button" id="clientarea-logmenu">
                                            <div>
                                                <i class="ri-history-line"></i>
                                                <span>Kayıtlar</span>
                                            </div>
                                            <div>
                                                <i class="ri-arrow-down-s-line"></i>
                                            </div>
                                        </a>
                                        <div class="bmenu-altmenu">
                                            <ul>
                                                <li class="has-mainmenu" data-page="client.log.alert" data-mainmenu="clientarea-logmenu">
                                                    <a href="<?= beGetRoute('client.log.alert') ?>">
                                                        <div>
                                                        <i class="ri-notification-line"></i>
                                                            <span>Bildirim Kayitlari</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.log.sms" data-mainmenu="clientarea-logmenu">
                                                    <a href="<?= beGetRoute('client.log.sms') ?>">
                                                        <div>
                                                            <i class="ri-phone-line"></i>
                                                            <span>SMS Kayıtları</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.log.email" data-mainmenu="clientarea-logmenu">
                                                    <a href="<?= beGetRoute('client.log.email') ?>">
                                                        <div>
                                                            <i class="ri-mail-send-line"></i>
                                                            <span>Mail Kayıtları</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.log.user" data-mainmenu="clientarea-logmenu">
                                                    <a href="<?= beGetRoute('client.log.user') ?>">
                                                        <div>
                                                            <i class="ri-user-location-line"></i>
                                                            <span>Kullanıcı Kayıtları</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="has-mainmenu" data-page="client.log.product" data-mainmenu="clientarea-logmenu">
                                                    <a href="<?= beGetRoute('client.log.product') ?>">
                                                        <div>
                                                            <i class="ri-shopping-cart-line"></i>
                                                            <span>Geçmiş Hizmet Kayıtları</span>
                                                        </div>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                    <li data-page="client.announcement">
                                        <a href="<?= beGetRoute('client.announcement') ?>">
                                            <div>
                                                <i class="ri-medal-2-line"></i>
                                                <span>Duyurular</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li data-page="client.banks">
                                        <a href="<?= beGetRoute('client.banks') ?>">
                                            <div>
                                            <i class="ri-bank-line"></i>
                                                <span>Banka Hesaplarımız</span>
                                            </div>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="bmenu">
                            <div class="bmenu-header">
                                <span>Hızlı Erişim</span>
                            </div>
                            <div class="bmenu-content">
                                <ul>
                                    <li>
                                        <a href="<?= beGetRoute('client.ticket.newticket') ?>">
                                            <div>
                                                <i class="ri-coupon-3-line"></i>
                                                <span>Destek Talebi Oluştur</span>
                                            </div>
                                        </a>
                                    </li>
                                    <?php if($be->settings['system_localmoney'] == 1): ?>
                                    <li>
                                        <a href="<?= beGetRoute('client.invoice.money') ?>">
                                            <div>
                                                <i class="ri-wallet-2-line"></i>
                                                <span>Kredi Yükleme</span>
                                            </div>
                                        </a>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-9 col-md-12">
                        <div class="bcontent">
                            <div class="card">
    <div class="card-header p-min">
        <div>
            <span>Makbuz Detayları</span>
        </div>
        <div>
        <img src="<?= $be->settings['system_logo_header'] ?>" width="auto" height="24" title="<?= beGetConfig('sitename') ?>" alt="<?= beGetConfig('sitename') ?>" crossorigin="anonymous">
        </div>
    </div>
    <div class="row mb-5 mt-5">
        <div class="col-4 text-center my-3">
            <span class="invoice-key">Makbuz No</span>
            <span class="invoice-val">#<?= $invoice['iid'] ?></span>
        </div>		
        <div class="col-4 text-center my-3">
            <span class="invoice-key">İsim</span>
            <span class="invoice-val"><?= $invoice['iname'] ?></span>
        </div>	
        <div class="col-4 text-center my-3">
            <span class="invoice-key">Açıklama</span>
            <span class="invoice-val"><?= $invoice['idescription'] ?></span>
        </div>
        <div class="col-4 text-center my-3">
            <span class="invoice-key">Ödeme Durumu</span>
            <span class="invoice-val"><?= $istatus[$invoice['istatus']] ?></span>
        </div>
        <div class="col-4 text-center my-3">
            <span class="invoice-key">Oluşturulma Tarihi</span>
            <span class="invoice-val"><?= date('d.m.Y',$invoice['idateline']) ?></span>
        </div>
        <div class="col-4 text-center my-3">
            <span class="invoice-key">Son Ödeme Tarihi</span>
            <span class="invoice-val"><?= date('d.m.Y H:i',$invoice['iexpiredate']) ?></span>
        </div>
    </div>	
    <div class="mt-3 p-5" style="overflow-x: auto;">
        <table class="btable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Hizmet Adı</th>
                    <th>Adet</th>
                    <th>Adet Fiyat</th>
                    <th>Vergi Oranı</th>
                    <th>Toplam Fiyat</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $counter = 1;
                ?>
                <?php foreach($invoiceitems as $item): ?>
                <tr>
                    <td><?= $counter ?></td>
                    <td><?= $item['iiname'] ?></td>
                    <td><?= $item['iiunitcount'] ?> Adet</td>
                    <td><?= $item['iiunitprice'] ?> <?= $currencies[$item['cid']]['cicon'] ?></td>
                    <td>
                        <?= $item['iitaxrate'] > 0 ? ('%'.$item['iitaxrate']):'-' ?>
                    </td>
                    <td><?= beMoneyFormat($item['iiunitprice']*$item['iiunitcount']) ?> <?= $currencies[$item['cid']]['cicon'] ?></td>
                </tr>
                <?php $counter += 1 ?>
                <?php endforeach; ?>
            </tbody>
        </table>			
    </div>
    <hr>
    <div class="row-flex row-end">
        <div class="px-5 my-2 text-end">
            <?php if($invoice['itaxprice'] > 0): ?>
            <div class="my-2">
                <span class="text-normal text-lg mr-1">Vergi:</span>
                <span class="text-normal text-lg"><?= beMoneyFormat($invoice['itaxprice']) ?> <?= $currencies[$invoice['cid']]['cicon'] ?></span>
            </div>
            <?php endif; ?>
            <?php if($invoice['idiscount'] > 0): ?>
            <div class="my-2">
                <span class="text-normal text-lg mr-1">İndirim:</span>
                <span class="text-normal text-lg"><?= beMoneyFormat($invoice['idiscount']) ?> <?= $currencies[$invoice['cid']]['cicon'] ?></span>
            </div>
            <?php endif; ?>
            <div>
                <span class="text-normal text-lg mr-1">Toplam:</span>
                <span class="text-normal text-lg"><?= beMoneyFormat($invoice['itotal']) ?> <?= $currencies[$invoice['cid']]['cicon'] ?></span>
            </div>
        </div>
    </div>
    <?php if($invoice['istatus'] == '0'): ?>
    <div class="row-flex row-center pb-4">
        <a href="<?= beGetRoute('client.invoice.invoice',['iid' => $invoice['iid']]) ?>?action=pay" class="btn btn-primary">Öde</a>
    </div>
    <?php endif; ?>
</div>
                        </div>
                    </div>
                </div>
            </div>
            
            <script>
                $(document).ready(function(){
                    var routename = "<?= beGetRouteName() ?>";
                    var item = $("li[data-page='"+routename+"']");
                    if(item.hasClass("has-mainmenu")){
                        $("#"+item.data("mainmenu")).trigger("click");
                    }
                    item.addClass("active");
                });
            </script>
            <?= $footer ?>
        </main>
    </body>
</html>