<!DOCTYPE html>
<html lang="en">
    <head>
        <base href="<?= beGetConfig('siteurl') ?>">
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />
        <link href="assets/beadmin/assets/css/plugins.bundle.css" rel="stylesheet" type="text/css" />
        <link href="assets/beadmin/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
        
        <script>
            var hostUrl = "";        
        </script>
        <script src="assets/beadmin/assets/plugins/global/plugins.bundle.js"></script>
        <script src="assets/beadmin/assets/js/scripts.bundle.js"></script>
    </head>
    <body id="kt_body" class="header-fixed header-tablet-and-mobile-fixed toolbar-enabled">
        <script>
            var defaultThemeMode = "system";
            var themeMode;
            if(document.documentElement){
                if(document.documentElement.hasAttribute("data-bs-theme-mode")){
                    themeMode = document.documentElement.getAttribute("data-bs-theme-mode");
                } 
                else{
                    if(localStorage.getItem("data-bs-theme") !== null){
                        themeMode = localStorage.getItem("data-bs-theme");
                    }
                    else{
                        themeMode = defaultThemeMode;
                    }			
                }
                if(themeMode === "system"){
                    themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light";
                }
                document.documentElement.setAttribute("data-bs-theme",themeMode);
            }            
        </script>
        <div class="d-flex flex-column flex-root">
            <div class="page d-flex flex-row flex-column-fluid">
                <div class="wrapper d-flex flex-column flex-row-fluid" id="kt_wrapper">
                    <div id="kt_header" class="header" data-kt-sticky="true" data-kt-sticky-name="header" data-kt-sticky-offset="{default: '200px', lg: '300px'}">
                        <div class="container-xxl  d-flex flex-grow-1 flex-stack">
                            <div class="d-flex align-items-center me-5">
                                <div class="d-lg-none btn btn-icon btn-active-color-primary w-30px h-30px ms-n2 me-3" id="kt_header_menu_toggle">
                                    <i class="ki-duotone ki-abstract-14 fs-2"> 
                                        <span class="path1"></span> 
                                        <span class="path2"></span> 
                                    </i> 
                                </div> 
                                <a href="<?= beGetRoute('admin.dashboard') ?>"> 
                                    <img alt="<?= beGetConfig('sitename') ?>" src="<?= $be->settings['system_logo_footer'] ?>" class="theme-dark-show h-20px h-lg-30px" /> 
                                    <img alt="<?= beGetConfig('sitename') ?>" src="<?= $be->settings['system_logo_header'] ?>" class="theme-light-show h-20px h-lg-30px" /> 
                                </a>
                            </div>
                            <div class="d-flex align-items-center flex-shrink-0">
                                <div id="kt_header_search" class="header-search d-flex align-items-center w-lg-250px" data-kt-search-keypress="true" data-kt-search-min-length="2" data-kt-search-enter="enter" data-kt-search-layout="menu" data-kt-search-responsive="lg" data-kt-menu-trigger="auto" data-kt-menu-permanent="true" data-kt-menu-placement="bottom-end">
                                    <div data-kt-search-element="toggle" class="search-toggle-mobile d-flex d-lg-none align-items-center">
                                        <div class="d-flex btn btn-icon btn-color-gray-700 btn-active-color-primary btn-outline btn-active-bg-light w-30px h-30px w-lg-40px h-lg-40px">
                                            <i class="ki-duotone ki-magnifier fs-1 text-gray-700 fs-2"> 
                                                <span class="path1"></span> 
                                                <span class="path2"></span> 
                                            </i> 
                                        </div>
                                    </div>
                                    <form data-kt-search-element="form" class="d-none d-lg-block w-100 position-relative mb-2 mb-lg-0" autocomplete="off"> 
                                        <input type="hidden" /> 
                                        <i class="ki-duotone ki-magnifier fs-2 text-gray-700 position-absolute top-50 translate-middle-y ms-4"> 
                                            <span class="path1"></span> 
                                            <span class="path2"></span> 
                                        </i> 
                                        <input type="text" class="form-control bg-transparent ps-13 fs-7 h-40px" name="search" value="" placeholder="Arama Yap" data-kt-search-element="input" /> 
                                        <span class="position-absolute top-50 end-0 translate-middle-y lh-0 d-none me-5" data-kt-search-element="spinner"> 
                                            <span class="spinner-border h-15px w-15px align-middle text-gray-500"></span> 
                                        </span> 
                                        <span class="btn btn-flush btn-active-color-primary position-absolute top-50 end-0 translate-middle-y lh-0 d-none me-4" data-kt-search-element="clear"> 
                                            <i class="ki-duotone ki-cross fs-2 fs-lg-1 me-0"> 
                                                <span class="path1"></span> 
                                                <span class="path2"></span> 
                                            </i> 
                                        </span> 
                                    </form>
                                    <div data-kt-search-element="content" class="menu menu-sub menu-sub-dropdown py-7 px-7 overflow-hidden w-300px w-md-350px">
                                        <div data-kt-search-element="wrapper">
                                            <div data-kt-search-element="results" class="d-none">
                                                <div class="scroll-y mh-200px mh-lg-350px">
                                                    <h3 class="fs-5 text-muted m-0  pb-5" data-kt-search-element="category-title">Users</h3> <a href="#" class="d-flex text-gray-900 text-hover-primary align-items-center mb-5">
                                                        <div class="symbol symbol-40px me-4"> <img src="/metronic8/demo11/assets/media/avatars/300-6.jpg" alt="" /> </div>
                                                        <div class="d-flex flex-column justify-content-start fw-semibold"> <span class="fs-6 fw-semibold">Karina Clark</span> <span class="fs-7 fw-semibold text-muted">Marketing Manager</span> </div>
                                                    </a>
                                                    <h3 class="fs-5 text-muted m-0 pt-5 pb-5" data-kt-search-element="category-title">Customers</h3> <a href="#" class="d-flex text-gray-900 text-hover-primary align-items-center mb-5">
                                                        <div class="symbol symbol-40px me-4"> <span class="symbol-label bg-light"> <img class="w-20px h-20px" src="/metronic8/demo11/assets/media/svg/brand-logos/volicity-9.svg" alt="" /> </span> </div>
                                                        <div class="d-flex flex-column justify-content-start fw-semibold"> <span class="fs-6 fw-semibold">Company Rbranding</span> <span class="fs-7 fw-semibold text-muted">UI Design</span> </div>
                                                    </a>
                                                </div>
                                            </div>
                                            <div class="" data-kt-search-element="main">
                                                <div class="d-flex flex-stack fw-semibold mb-4"> <span class="text-muted fs-6 me-2">Recently Searched:</span> </div>
                                                <div class="scroll-y mh-200px mh-lg-325px">
                                                    <div class="d-flex align-items-center mb-5">
                                                        <div class="symbol symbol-40px me-4"> <span class="symbol-label bg-light"> <i class="ki-duotone ki-laptop fs-2 text-primary"> <span class="path1"></span> <span class="path2"></span> </i> </span> </div>
                                                        <div class="d-flex flex-column"> <a href="#" class="fs-6 text-gray-800 text-hover-primary fw-semibold">BoomApp by Keenthemes</a> <span class="fs-7 text-muted fw-semibold">#45789</span> </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div data-kt-search-element="empty" class="text-center d-none">
                                                <div class="pt-10 pb-10"> <i class="ki-duotone ki-search-list fs-4x opacity-50"> <span class="path1"></span> <span class="path2"></span> <span class="path3"></span> </i> </div>
                                                <div class="pb-15 fw-semibold">
                                                    <h3 class="text-gray-600 fs-5 mb-2">No result found</h3>
                                                    <div class="text-muted fs-7">Please try again with a different query</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center ms-3 ms-lg-4">
                                    <div class="btn btn-icon btn-color-gray-700 btn-active-color-primary btn-outline btn-active-bg-light w-30px h-30px w-lg-40px h-lg-40px" id="kt_activities_toggle"> <i class="ki-duotone ki-chart-simple fs-1"> <span class="path1"></span> <span class="path2"></span> <span class="path3"></span> <span class="path4"></span> </i> </div>
                                </div>
                                <div class="d-flex align-items-center ms-3 ms-lg-4"> <a href="#" class="btn btn-icon btn-color-gray-700 btn-active-color-primary btn-outline btn-active-bg-light w-30px h-30px w-lg-40px h-lg-40px" data-kt-menu-trigger="{default:'click', lg: 'hover'}" data-kt-menu-attach="parent" data-kt-menu-placement="bottom-end"> <i class="ki-duotone ki-night-day theme-light-show fs-1"> <span class="path1"></span> <span class="path2"></span> <span class="path3"></span> <span class="path4"></span> <span class="path5"></span> <span class="path6"></span> <span class="path7"></span> <span class="path8"></span> <span class="path9"></span> <span class="path10"></span> </i> <i class="ki-duotone ki-moon theme-dark-show fs-1"> <span class="path1"></span> <span class="path2"></span> </i> </a>
                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-title-gray-700 menu-icon-gray-500 menu-active-bg menu-state-color fw-semibold py-4 fs-base w-150px" data-kt-menu="true" data-kt-element="theme-mode-menu">
                                        <div class="menu-item px-3 my-0"> <a href="#" class="menu-link px-3 py-2" data-kt-element="mode" data-kt-value="light"> <span class="menu-icon" data-kt-element="icon"> <i class="ki-duotone ki-night-day fs-2"> <span class="path1"></span> <span class="path2"></span> <span class="path3"></span> <span class="path4"></span> <span class="path5"></span> <span class="path6"></span> <span class="path7"></span> <span class="path8"></span> <span class="path9"></span> <span class="path10"></span> </i> </span> <span class="menu-title">Light</span> </a> </div>
                                        <div class="menu-item px-3 my-0"> <a href="#" class="menu-link px-3 py-2" data-kt-element="mode" data-kt-value="dark"> <span class="menu-icon" data-kt-element="icon"> <i class="ki-duotone ki-moon fs-2"> <span class="path1"></span> <span class="path2"></span> </i> </span> <span class="menu-title">Dark</span> </a> </div>
                                        <div class="menu-item px-3 my-0"> <a href="#" class="menu-link px-3 py-2" data-kt-element="mode" data-kt-value="system"> <span class="menu-icon" data-kt-element="icon"> <i class="ki-duotone ki-screen fs-2"> <span class="path1"></span> <span class="path2"></span> <span class="path3"></span> <span class="path4"></span> </i> </span> <span class="menu-title">System</span> </a> </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center ms-3 ms-lg-4" id="kt_header_user_menu_toggle">
                                    <div class="btn btn-icon btn-color-gray-700 btn-active-color-primary btn-outline btn-active-bg-light w-30px h-30px w-lg-40px h-lg-40px" data-kt-menu-trigger="click" data-kt-menu-attach="parent" data-kt-menu-placement="bottom-end"> 
                                        <i class="ki-duotone ki-user fs-1"> 
                                            <span class="path1"></span> 
                                            <span class="path2"></span> 
                                        </i>
                                    </div>
                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg menu-state-color fw-semibold py-4 fs-6 w-275px" data-kt-menu="true">
                                        <div class="menu-item px-3">
                                            <div class="menu-content d-flex align-items-center px-3">
                                                <div class="d-flex flex-column">
                                                    <div class="fw-bold d-flex align-items-center fs-5"><?= $be->user['name'].' '.$be->user['surname'] ?> </div>
                                                    <span class="fw-semibold text-muted text-hover-primary fs-7"><?= $be->user['email'] ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="separator my-2"></div>
                                        <div class="menu-item px-5 my-1">
                                            <a href="<?= beGetRoute('auth.changepassword') ?>" class="menu-link px-5"> Şifremi Değiştir</a> 
                                        </div>
                                        <div class="menu-item px-5"> 
                                            <a href="<?= beGetRoute('auth.logout') ?>" class="menu-link px-5">Çıkış Yap</a> 
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="separator"></div>
                        <div class="header-menu-container  container-xxl  d-flex flex-stack h-lg-75px w-100" id="kt_header_nav">
                            <div class="header-menu flex-column flex-lg-row" data-kt-drawer="true" data-kt-drawer-name="header-menu" data-kt-drawer-activate="{default: true, lg: false}" data-kt-drawer-overlay="true" data-kt-drawer-width="{default:'200px', '300px': '250px'}" data-kt-drawer-direction="start" data-kt-drawer-toggle="#kt_header_menu_toggle" data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_body', lg: '#kt_header_nav'}">
                                <div class="menu menu-rounded menu-column menu-lg-row menu-root-here-bg-desktop menu-active-bg menu-state-primary menu-title-gray-800 menu-arrow-gray-500  align-items-stretch flex-grow-1  my-5 my-lg-0 px-2 px-lg-0 fw-semibold fs-6" id="#kt_header_menu" data-kt-menu="true">
                                    <div class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.dashboard') ?>">
                                            <span class="menu-title">Ana Sayfa</span>
                                            <span class="menu-arrow d-lg-none"></span>
                                        </a>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Kullanıcı Sistemi</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.user.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kullanıcılar</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.user.add') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kullanıcı Oluştur</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.user.group.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Grup Yönetimi</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Sipariş</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.order.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Siparişler</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.order.list') ?>?type=2">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Aktif Siparişler</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.order.list') ?>?type=0">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Siparişler</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.order.add') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Sipariş Oluştur</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Ürün Yönetimi</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.product.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Ürünler</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.category.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kategoriler</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.addon.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Ürün Eklentileri</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.category.add') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kategori Oluştur</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.product.add') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Ürün Oluştur</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Destek Sistemi</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Talepler</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.list.active') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Aktif Destek Talepleri</span> 
                                                    <?php if($be->ticketstats['active']): ?>
                                                    <span class="menu-badge"><span class="badge badge-success"><?= $be->ticketstats['active'] ?></span></span>
                                                    <?php endif; ?>
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.list.inprocess') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">İşlemdeki Destek Talepleri</span> 
                                                    <?php if($be->ticketstats['inprocess']): ?>
                                                    <span class="menu-badge"><span class="badge badge-success"><?= $be->ticketstats['inprocess'] ?></span></span>
                                                    <?php endif; ?>
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.list.closed') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kapatılmış Destek Talepleri</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.depertment.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Destek Departmanları</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.predefined.category.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Hazır Destek Mesajlar</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.add') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Talep Oluştur</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Muhasebe</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.invoice.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Faturalar</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.accounting.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Muhasebe</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.accounting.periodic.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Sabit İşlemler Yönetimi</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.accounting.bank.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Banka Hesapları</span> 
                                                </a> 
                                            </div>
                                            <div data-kt-menu-trigger="{default:'click', lg: 'hover'}" data-kt-menu-placement="right-start" class="menu-item menu-lg-down-accordion">
                                                <span class="menu-link py-3">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-rocket fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                        </i>
                                                    </span>
                                                    <span class="menu-title">Pazarlama Yönetimi</span> 
                                                    <span class="menu-arrow"></span> 
                                                </span>
                                                <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown menu-active-bg px-lg-2 py-lg-4 w-lg-225px">
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.coupon.list') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Kupon Yönetimi</span>
                                                        </a>
                                                    </div>
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.marketing.send.message') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Bilgilendirme Mesajı Gönder</span>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Ayarlar</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.settings.settinggroups') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Genel Ayarlar</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.settings.module') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Modül Ayarları</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.settings.server') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Sunucu Ayarları</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.task.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Görev Yönetimi</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.language.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Dil Yönetimi</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.currency.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Para Birimi Yönetimi</span> 
                                                </a> 
                                            </div>
                                            <div data-kt-menu-trigger="{default:'click', lg: 'hover'}" data-kt-menu-placement="right-start" class="menu-item menu-lg-down-accordion">
                                                <span class="menu-link py-3">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-rocket fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                        </i>
                                                    </span>
                                                    <span class="menu-title">Görüntü & Yazı Yönetimi</span> 
                                                    <span class="menu-arrow"></span> 
                                                </span>
                                                <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown menu-active-bg px-lg-2 py-lg-4 w-lg-225px">
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.menu.list') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Menü Yönetimi</span>
                                                        </a>
                                                    </div>
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.theme.list') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Tema Yönetimi</span>
                                                        </a>
                                                    </div>
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.theme.page.list') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Tema Sayfa Yönetimi</span>
                                                        </a>
                                                    </div>
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.messagetemplate.list') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Mesaj Şablonu Yönetimi</span>
                                                        </a>
                                                    </div>
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.page.list') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Sayfa Yönetimi</span>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.update') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Sistem Güncellemeleri</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Kayıtlar</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.log.system') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Sistem Kayıtları</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.log.module') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Modül Kayıtları</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.log.user') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kullanıcı Kayıtları</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.log.userproduct') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kullanıcı Ürün Kayıtları</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Eklenti</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.application.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Mağza</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.application.downloaded') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Yüklü Eklentiler</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-shrink-0 p-4 p-lg-0 me-lg-2"> <a href="https://wiki.diyocp.com" class="btn btn-sm btn-light-primary fw-bold w-100 w-lg-auto" title="WIKI">WIKI</a></div>
                            </div>
                        </div>
                    </div>
                    <div class="toolbar py-5 py-lg-5" id="kt_toolbar"></div>
                    <div id="kt_content_container" class="d-flex flex-column-fluid align-items-start container-xxl">
                        <div class="content flex-row-fluid" id="kt_content">
                            <div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="d-flex justify-content-end">
            <a href="<?= beGetRoute('admin.currency.add') ?>" class="d-inline-flex align-items-center btn btn-primary mb-5">
                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"/>
                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"/>
                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"/>
                    </svg>
                </span>
                Yeni Ekle
            </a>
        </div>
        <div class="card mb-4">
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">#</th>
                            <th class="text-center align-middle">Para Birimi</th>
                            <th class="text-center align-middle">Dönüşüm Oranı</th>
                            <th class="text-center align-middle">Temel Vergi Oranı</th>
                            <th class="text-center align-middle">Durum</th>
                            <th class="text-center align-middle"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($currencies as $currency): ?>
                        <tr id="<?= $currency['cid'] ?>Row">
                            <td class="text-center align-middle"><?= $currency['cid'] ?></td>
                            <td class="text-center align-middle"><?= $currency['cname'].' / '.$currency['ccode'] ?></td>
                            <td class="text-center align-middle"><?= $currency['crate'] ?></td>
                            <td class="text-center align-middle"><?= $currency['ctaxrate'] ?></td>
                            <?php if($be->settings['system_currency'] == $currency['cid']): ?>
                            <td class="text-center align-middle">
                                <span class="badge badge-success">Temel</span>
                            </td>
                            <?php else: ?>
                            <td class="text-center align-middle">
                                <a data-bs-toggle="tooltip" title="Temel Olarak Ayarla" href="#" class="btn btn-info btnSetDefault" data-cid="<?= $currency['cid'] ?>">Temel Olarak Ayarla</a>
                            </td>
                            <?php endif; ?>
                            <td class="text-center align-middle">
                                <a data-bs-toggle="tooltip" title="Düzenle" href="<?= beGetRoute('admin.currency.edit',['cid' => $currency['cid']]) ?>" class="btn btn-primary">Düzenle</a>
                                <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDelete" data-cid="<?= $currency['cid'] ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"/><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/></svg>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
                        </div>
                    </div>
                    <div class="footer py-4 d-flex flex-lg-column " id="kt_footer">
                        <div class=" container-xxl  d-flex flex-column flex-md-row align-items-center justify-content-between">
                            <div class="text-gray-900 order-2 order-md-1"> <span class="text-muted fw-semibold me-1"><?= date('Y') ?>&copy;</span> <a href="https://www.diyocp.com" target="_blank" class="text-gray-800 text-hover-primary"><?= beGetConfig('sitename') ?></a> </div>
                            <ul class="menu menu-gray-600 menu-hover-primary fw-semibold order-1">
                                <li class="menu-item"> <a href="https://wiki.diyocp.com" target="_blank" class="menu-link px-2">WIKI</a> </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="kt_scrolltop" class="scrolltop" data-kt-scrolltop="true">
            <i class="ki-duotone ki-arrow-up">
                <span class="path1"></span>
                <span class="path2"></span>
            </i> 
        </div>
        <script>
    $(".form-control-select").select2();
    $(".btnSetDefault").on("click",function(){
        var cid = $(this).data("cid");
        $.ajax({
            url: "<?= beGetRoute('admin.currency.default.post') ?>",
            type: "post",
            data: {cid:cid},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    Swal.fire("Başarılı",response.message,"success");
                    setTimeout(function(){
                        location.reload();
                    },1000);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });	
        return false;
    });
    $(".btnDelete").on("click",function(){
        var cid = $(this).data("cid");
        Swal.fire({
            html: "Bu işlem sonucunda para birimi kalıcı olarak silincektir onaylıyor musunuz?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "<?= beGetRoute('admin.currency.delete.post') ?>",
                    type: "post",
                    data: {cid:cid},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            $("#"+cid+"Row").remove();
                            Swal.fire("Başarılı",response.message,"success");
            
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
</script>
    </body>
</html>