<!DOCTYPE html>
<html lang="en">
    <head>
        <base href="<?= beGetConfig('siteurl') ?>">
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />
        <link href="assets/beadmin/assets/css/plugins.bundle.css" rel="stylesheet" type="text/css" />
        <link href="assets/beadmin/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
        
        <script>
            var hostUrl = "";        
        </script>
        <script src="assets/beadmin/assets/plugins/global/plugins.bundle.js"></script>
        <script src="assets/beadmin/assets/js/scripts.bundle.js"></script>
    </head>
    <body id="kt_body" class="header-fixed header-tablet-and-mobile-fixed toolbar-enabled">
        <script>
            var defaultThemeMode = "system";
            var themeMode;
            if(document.documentElement){
                if(document.documentElement.hasAttribute("data-bs-theme-mode")){
                    themeMode = document.documentElement.getAttribute("data-bs-theme-mode");
                } 
                else{
                    if(localStorage.getItem("data-bs-theme") !== null){
                        themeMode = localStorage.getItem("data-bs-theme");
                    }
                    else{
                        themeMode = defaultThemeMode;
                    }			
                }
                if(themeMode === "system"){
                    themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light";
                }
                document.documentElement.setAttribute("data-bs-theme",themeMode);
            }            
        </script>
        <div class="d-flex flex-column flex-root">
            <div class="page d-flex flex-row flex-column-fluid">
                <div class="wrapper d-flex flex-column flex-row-fluid" id="kt_wrapper">
                    <div id="kt_header" class="header" data-kt-sticky="true" data-kt-sticky-name="header" data-kt-sticky-offset="{default: '200px', lg: '300px'}">
                        <div class="container-xxl  d-flex flex-grow-1 flex-stack">
                            <div class="d-flex align-items-center me-5">
                                <div class="d-lg-none btn btn-icon btn-active-color-primary w-30px h-30px ms-n2 me-3" id="kt_header_menu_toggle">
                                    <i class="ki-duotone ki-abstract-14 fs-2"> 
                                        <span class="path1"></span> 
                                        <span class="path2"></span> 
                                    </i> 
                                </div> 
                                <a href="<?= beGetRoute('admin.dashboard') ?>"> 
                                    <img alt="<?= beGetConfig('sitename') ?>" src="<?= $be->settings['system_logo_footer'] ?>" class="theme-dark-show h-20px h-lg-30px" /> 
                                    <img alt="<?= beGetConfig('sitename') ?>" src="<?= $be->settings['system_logo_header'] ?>" class="theme-light-show h-20px h-lg-30px" /> 
                                </a>
                            </div>
                            <div class="d-flex align-items-center flex-shrink-0">
                                <div id="kt_header_search" class="header-search d-flex align-items-center w-lg-250px" data-kt-search-keypress="true" data-kt-search-min-length="2" data-kt-search-enter="enter" data-kt-search-layout="menu" data-kt-search-responsive="lg" data-kt-menu-trigger="auto" data-kt-menu-permanent="true" data-kt-menu-placement="bottom-end">
                                    <div data-kt-search-element="toggle" class="search-toggle-mobile d-flex d-lg-none align-items-center">
                                        <div class="d-flex btn btn-icon btn-color-gray-700 btn-active-color-primary btn-outline btn-active-bg-light w-30px h-30px w-lg-40px h-lg-40px">
                                            <i class="ki-duotone ki-magnifier fs-1 text-gray-700 fs-2"> 
                                                <span class="path1"></span> 
                                                <span class="path2"></span> 
                                            </i> 
                                        </div>
                                    </div>
                                    <form data-kt-search-element="form" class="d-none d-lg-block w-100 position-relative mb-2 mb-lg-0" autocomplete="off"> 
                                        <input type="hidden" /> 
                                        <i class="ki-duotone ki-magnifier fs-2 text-gray-700 position-absolute top-50 translate-middle-y ms-4"> 
                                            <span class="path1"></span> 
                                            <span class="path2"></span> 
                                        </i> 
                                        <input type="text" class="form-control bg-transparent ps-13 fs-7 h-40px" name="search" value="" placeholder="Arama Yap" data-kt-search-element="input" /> 
                                        <span class="position-absolute top-50 end-0 translate-middle-y lh-0 d-none me-5" data-kt-search-element="spinner"> 
                                            <span class="spinner-border h-15px w-15px align-middle text-gray-500"></span> 
                                        </span> 
                                        <span class="btn btn-flush btn-active-color-primary position-absolute top-50 end-0 translate-middle-y lh-0 d-none me-4" data-kt-search-element="clear"> 
                                            <i class="ki-duotone ki-cross fs-2 fs-lg-1 me-0"> 
                                                <span class="path1"></span> 
                                                <span class="path2"></span> 
                                            </i> 
                                        </span> 
                                    </form>
                                    <div data-kt-search-element="content" class="menu menu-sub menu-sub-dropdown py-7 px-7 overflow-hidden w-300px w-md-350px">
                                        <div data-kt-search-element="wrapper">
                                            <div data-kt-search-element="results" class="d-none">
                                                <div class="scroll-y mh-200px mh-lg-350px">
                                                    <h3 class="fs-5 text-muted m-0  pb-5" data-kt-search-element="category-title">Users</h3> <a href="#" class="d-flex text-gray-900 text-hover-primary align-items-center mb-5">
                                                        <div class="symbol symbol-40px me-4"> <img src="/metronic8/demo11/assets/media/avatars/300-6.jpg" alt="" /> </div>
                                                        <div class="d-flex flex-column justify-content-start fw-semibold"> <span class="fs-6 fw-semibold">Karina Clark</span> <span class="fs-7 fw-semibold text-muted">Marketing Manager</span> </div>
                                                    </a>
                                                    <h3 class="fs-5 text-muted m-0 pt-5 pb-5" data-kt-search-element="category-title">Customers</h3> <a href="#" class="d-flex text-gray-900 text-hover-primary align-items-center mb-5">
                                                        <div class="symbol symbol-40px me-4"> <span class="symbol-label bg-light"> <img class="w-20px h-20px" src="/metronic8/demo11/assets/media/svg/brand-logos/volicity-9.svg" alt="" /> </span> </div>
                                                        <div class="d-flex flex-column justify-content-start fw-semibold"> <span class="fs-6 fw-semibold">Company Rbranding</span> <span class="fs-7 fw-semibold text-muted">UI Design</span> </div>
                                                    </a>
                                                </div>
                                            </div>
                                            <div class="" data-kt-search-element="main">
                                                <div class="d-flex flex-stack fw-semibold mb-4"> <span class="text-muted fs-6 me-2">Recently Searched:</span> </div>
                                                <div class="scroll-y mh-200px mh-lg-325px">
                                                    <div class="d-flex align-items-center mb-5">
                                                        <div class="symbol symbol-40px me-4"> <span class="symbol-label bg-light"> <i class="ki-duotone ki-laptop fs-2 text-primary"> <span class="path1"></span> <span class="path2"></span> </i> </span> </div>
                                                        <div class="d-flex flex-column"> <a href="#" class="fs-6 text-gray-800 text-hover-primary fw-semibold">BoomApp by Keenthemes</a> <span class="fs-7 text-muted fw-semibold">#45789</span> </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div data-kt-search-element="empty" class="text-center d-none">
                                                <div class="pt-10 pb-10"> <i class="ki-duotone ki-search-list fs-4x opacity-50"> <span class="path1"></span> <span class="path2"></span> <span class="path3"></span> </i> </div>
                                                <div class="pb-15 fw-semibold">
                                                    <h3 class="text-gray-600 fs-5 mb-2">No result found</h3>
                                                    <div class="text-muted fs-7">Please try again with a different query</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center ms-3 ms-lg-4">
                                    <div class="btn btn-icon btn-color-gray-700 btn-active-color-primary btn-outline btn-active-bg-light w-30px h-30px w-lg-40px h-lg-40px" id="kt_activities_toggle"> <i class="ki-duotone ki-chart-simple fs-1"> <span class="path1"></span> <span class="path2"></span> <span class="path3"></span> <span class="path4"></span> </i> </div>
                                </div>
                                <div class="d-flex align-items-center ms-3 ms-lg-4"> <a href="#" class="btn btn-icon btn-color-gray-700 btn-active-color-primary btn-outline btn-active-bg-light w-30px h-30px w-lg-40px h-lg-40px" data-kt-menu-trigger="{default:'click', lg: 'hover'}" data-kt-menu-attach="parent" data-kt-menu-placement="bottom-end"> <i class="ki-duotone ki-night-day theme-light-show fs-1"> <span class="path1"></span> <span class="path2"></span> <span class="path3"></span> <span class="path4"></span> <span class="path5"></span> <span class="path6"></span> <span class="path7"></span> <span class="path8"></span> <span class="path9"></span> <span class="path10"></span> </i> <i class="ki-duotone ki-moon theme-dark-show fs-1"> <span class="path1"></span> <span class="path2"></span> </i> </a>
                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-title-gray-700 menu-icon-gray-500 menu-active-bg menu-state-color fw-semibold py-4 fs-base w-150px" data-kt-menu="true" data-kt-element="theme-mode-menu">
                                        <div class="menu-item px-3 my-0"> <a href="#" class="menu-link px-3 py-2" data-kt-element="mode" data-kt-value="light"> <span class="menu-icon" data-kt-element="icon"> <i class="ki-duotone ki-night-day fs-2"> <span class="path1"></span> <span class="path2"></span> <span class="path3"></span> <span class="path4"></span> <span class="path5"></span> <span class="path6"></span> <span class="path7"></span> <span class="path8"></span> <span class="path9"></span> <span class="path10"></span> </i> </span> <span class="menu-title">Light</span> </a> </div>
                                        <div class="menu-item px-3 my-0"> <a href="#" class="menu-link px-3 py-2" data-kt-element="mode" data-kt-value="dark"> <span class="menu-icon" data-kt-element="icon"> <i class="ki-duotone ki-moon fs-2"> <span class="path1"></span> <span class="path2"></span> </i> </span> <span class="menu-title">Dark</span> </a> </div>
                                        <div class="menu-item px-3 my-0"> <a href="#" class="menu-link px-3 py-2" data-kt-element="mode" data-kt-value="system"> <span class="menu-icon" data-kt-element="icon"> <i class="ki-duotone ki-screen fs-2"> <span class="path1"></span> <span class="path2"></span> <span class="path3"></span> <span class="path4"></span> </i> </span> <span class="menu-title">System</span> </a> </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center ms-3 ms-lg-4" id="kt_header_user_menu_toggle">
                                    <div class="btn btn-icon btn-color-gray-700 btn-active-color-primary btn-outline btn-active-bg-light w-30px h-30px w-lg-40px h-lg-40px" data-kt-menu-trigger="click" data-kt-menu-attach="parent" data-kt-menu-placement="bottom-end"> 
                                        <i class="ki-duotone ki-user fs-1"> 
                                            <span class="path1"></span> 
                                            <span class="path2"></span> 
                                        </i>
                                    </div>
                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg menu-state-color fw-semibold py-4 fs-6 w-275px" data-kt-menu="true">
                                        <div class="menu-item px-3">
                                            <div class="menu-content d-flex align-items-center px-3">
                                                <div class="d-flex flex-column">
                                                    <div class="fw-bold d-flex align-items-center fs-5"><?= $be->user['name'].' '.$be->user['surname'] ?> </div>
                                                    <span class="fw-semibold text-muted text-hover-primary fs-7"><?= $be->user['email'] ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="separator my-2"></div>
                                        <div class="menu-item px-5 my-1">
                                            <a href="<?= beGetRoute('auth.changepassword') ?>" class="menu-link px-5"> Şifremi Değiştir</a> 
                                        </div>
                                        <div class="menu-item px-5"> 
                                            <a href="<?= beGetRoute('auth.logout') ?>" class="menu-link px-5">Çıkış Yap</a> 
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="separator"></div>
                        <div class="header-menu-container  container-xxl  d-flex flex-stack h-lg-75px w-100" id="kt_header_nav">
                            <div class="header-menu flex-column flex-lg-row" data-kt-drawer="true" data-kt-drawer-name="header-menu" data-kt-drawer-activate="{default: true, lg: false}" data-kt-drawer-overlay="true" data-kt-drawer-width="{default:'200px', '300px': '250px'}" data-kt-drawer-direction="start" data-kt-drawer-toggle="#kt_header_menu_toggle" data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_body', lg: '#kt_header_nav'}">
                                <div class="menu menu-rounded menu-column menu-lg-row menu-root-here-bg-desktop menu-active-bg menu-state-primary menu-title-gray-800 menu-arrow-gray-500  align-items-stretch flex-grow-1  my-5 my-lg-0 px-2 px-lg-0 fw-semibold fs-6" id="#kt_header_menu" data-kt-menu="true">
                                    <div class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.dashboard') ?>">
                                            <span class="menu-title">Ana Sayfa</span>
                                            <span class="menu-arrow d-lg-none"></span>
                                        </a>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Kullanıcı Sistemi</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.user.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kullanıcılar</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.user.add') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kullanıcı Oluştur</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.user.group.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Grup Yönetimi</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Sipariş</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.order.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Siparişler</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.order.list') ?>?type=2">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Aktif Siparişler</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.order.list') ?>?type=0">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Siparişler</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.order.add') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Sipariş Oluştur</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Ürün Yönetimi</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.product.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Ürünler</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.category.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kategoriler</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.addon.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Ürün Eklentileri</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.category.add') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kategori Oluştur</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.product.add') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Ürün Oluştur</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Destek Sistemi</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Talepler</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.list.active') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Aktif Destek Talepleri</span> 
                                                    <?php if($be->ticketstats['active']): ?>
                                                    <span class="menu-badge"><span class="badge badge-success"><?= $be->ticketstats['active'] ?></span></span>
                                                    <?php endif; ?>
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.list.inprocess') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">İşlemdeki Destek Talepleri</span> 
                                                    <?php if($be->ticketstats['inprocess']): ?>
                                                    <span class="menu-badge"><span class="badge badge-success"><?= $be->ticketstats['inprocess'] ?></span></span>
                                                    <?php endif; ?>
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.list.closed') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kapatılmış Destek Talepleri</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.depertment.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Destek Departmanları</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.predefined.category.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Hazır Destek Mesajlar</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.ticket.add') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Talep Oluştur</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Muhasebe</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.invoice.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Faturalar</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.accounting.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Muhasebe</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.accounting.periodic.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Sabit İşlemler Yönetimi</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.accounting.bank.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Banka Hesapları</span> 
                                                </a> 
                                            </div>
                                            <div data-kt-menu-trigger="{default:'click', lg: 'hover'}" data-kt-menu-placement="right-start" class="menu-item menu-lg-down-accordion">
                                                <span class="menu-link py-3">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-rocket fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                        </i>
                                                    </span>
                                                    <span class="menu-title">Pazarlama Yönetimi</span> 
                                                    <span class="menu-arrow"></span> 
                                                </span>
                                                <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown menu-active-bg px-lg-2 py-lg-4 w-lg-225px">
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.coupon.list') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Kupon Yönetimi</span>
                                                        </a>
                                                    </div>
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.marketing.send.message') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Bilgilendirme Mesajı Gönder</span>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Ayarlar</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.settings.settinggroups') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Genel Ayarlar</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.settings.module') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Modül Ayarları</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.settings.server') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Sunucu Ayarları</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.task.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Görev Yönetimi</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.language.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Dil Yönetimi</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.currency.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Para Birimi Yönetimi</span> 
                                                </a> 
                                            </div>
                                            <div data-kt-menu-trigger="{default:'click', lg: 'hover'}" data-kt-menu-placement="right-start" class="menu-item menu-lg-down-accordion">
                                                <span class="menu-link py-3">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-rocket fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                        </i>
                                                    </span>
                                                    <span class="menu-title">Görüntü & Yazı Yönetimi</span> 
                                                    <span class="menu-arrow"></span> 
                                                </span>
                                                <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown menu-active-bg px-lg-2 py-lg-4 w-lg-225px">
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.menu.list') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Menü Yönetimi</span>
                                                        </a>
                                                    </div>
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.theme.list') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Tema Yönetimi</span>
                                                        </a>
                                                    </div>
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.theme.page.list') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Tema Sayfa Yönetimi</span>
                                                        </a>
                                                    </div>
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.messagetemplate.list') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Mesaj Şablonu Yönetimi</span>
                                                        </a>
                                                    </div>
                                                    <div class="menu-item">
                                                        <a class="menu-link py-3" href="<?= beGetRoute('admin.page.list') ?>">
                                                            <span class="menu-bullet">
                                                                <span class="bullet bullet-dot"></span> 
                                                            </span> 
                                                            <span class="menu-title">Sayfa Yönetimi</span>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.update') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Sistem Güncellemeleri</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Kayıtlar</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.log.system') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Sistem Kayıtları</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.log.module') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Modül Kayıtları</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.log.user') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kullanıcı Kayıtları</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.log.userproduct') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Kullanıcı Ürün Kayıtları</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                    <div data-kt-menu-trigger="{default: 'click', lg: 'hover'}" data-kt-menu-placement="bottom-start" class="menu-item menu-lg-down-accordion menu-sub-lg-down-indention me-0 me-lg-2">
                                        <span class="menu-link py-3"> 
                                            <span class="menu-title">Eklenti</span> 
                                            <span class="menu-arrow d-lg-none"></span> 
                                        </span>
                                        <div class="menu-sub menu-sub-lg-down-accordion menu-sub-lg-dropdown px-lg-2 py-lg-4 w-lg-250px">
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.application.list') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Mağza</span> 
                                                </a> 
                                            </div>
                                            <div class="menu-item"> 
                                                <a class="menu-link py-3" href="<?= beGetRoute('admin.application.downloaded') ?>">
                                                    <span class="menu-icon">
                                                        <i class="ki-duotone ki-calendar-8 fs-2">
                                                            <span class="path1"></span>
                                                            <span class="path2"></span>
                                                            <span class="path3"></span>
                                                            <span class="path4"></span>
                                                            <span class="path5"></span>
                                                            <span class="path6"></span>
                                                        </i> 
                                                    </span> 
                                                    <span class="menu-title">Yüklü Eklentiler</span> 
                                                </a> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-shrink-0 p-4 p-lg-0 me-lg-2"> <a href="https://wiki.diyocp.com" class="btn btn-sm btn-light-primary fw-bold w-100 w-lg-auto" title="WIKI">WIKI</a></div>
                            </div>
                        </div>
                    </div>
                    <div class="toolbar py-5 py-lg-5" id="kt_toolbar"></div>
                    <div id="kt_content_container" class="d-flex flex-column-fluid align-items-start container-xxl">
                        <div class="content flex-row-fluid" id="kt_content">
                            <div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-4">
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">Uygulama</th>
                            <th class="text-center align-middle">Yapımcı</th>
                            <th class="text-center align-middle">Açıklama</th>
                            <th class="text-center align-middle">Versiyon</th>
                            <th class="text-center align-middle"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($plugins as $name => $plugin): ?>
                        <tr>
                            <td class="text-center align-middle"><?= $plugin['name'] ?></td>
                            <td class="text-center align-middle"><?= $plugin['author'] ?></td>
                            <td class="text-center align-middle"><?= $plugin['description'] ?></td>
                            <td class="text-center align-middle"><?= $plugin['version'] ?></td>
                            <td class="text-center align-middle">
                                <?php if($plugin['data']): ?>
                                <?php if($plugin['data']['plstatus'] == 0): ?>
                                <a data-bs-toggle="tooltip" title="Aktif Et" class="btn btn-info btnAction" data-plugin="<?= $name ?>" data-action="active">
                                    <span class="svg-icon svg-icon-2 mx-0">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.3" d="M20.0381 4V10C20.0381 10.6 19.6381 11 19.0381 11H17.0381C16.4381 11 16.0381 10.6 16.0381 10V4C16.0381 2.9 16.9381 2 18.0381 2C19.1381 2 20.0381 2.9 20.0381 4ZM9.73808 18.9C10.7381 18.5 11.2381 17.3 10.8381 16.3L5.83808 3.29999C5.43808 2.29999 4.23808 1.80001 3.23808 2.20001C2.23808 2.60001 1.73809 3.79999 2.13809 4.79999L7.13809 17.8C7.43809 18.6 8.23808 19.1 9.03808 19.1C9.23808 19 9.53808 19 9.73808 18.9ZM19.0381 18H17.0381V20H19.0381V18Z" fill="currentColor"/>
                                            <path d="M18.0381 6H4.03809C2.93809 6 2.03809 5.1 2.03809 4C2.03809 2.9 2.93809 2 4.03809 2H18.0381C19.1381 2 20.0381 2.9 20.0381 4C20.0381 5.1 19.1381 6 18.0381 6ZM4.03809 3C3.43809 3 3.03809 3.4 3.03809 4C3.03809 4.6 3.43809 5 4.03809 5C4.63809 5 5.03809 4.6 5.03809 4C5.03809 3.4 4.63809 3 4.03809 3ZM18.0381 3C17.4381 3 17.0381 3.4 17.0381 4C17.0381 4.6 17.4381 5 18.0381 5C18.6381 5 19.0381 4.6 19.0381 4C19.0381 3.4 18.6381 3 18.0381 3ZM12.0381 17V22H6.03809V17C6.03809 15.3 7.33809 14 9.03809 14C10.7381 14 12.0381 15.3 12.0381 17ZM9.03809 15.5C8.23809 15.5 7.53809 16.2 7.53809 17C7.53809 17.8 8.23809 18.5 9.03809 18.5C9.83809 18.5 10.5381 17.8 10.5381 17C10.5381 16.2 9.83809 15.5 9.03809 15.5ZM15.0381 15H17.0381V13H16.0381V8L14.0381 10V14C14.0381 14.6 14.4381 15 15.0381 15ZM19.0381 15H21.0381C21.6381 15 22.0381 14.6 22.0381 14V10L20.0381 8V13H19.0381V15ZM21.0381 20H15.0381V22H21.0381V20Z" fill="currentColor"/>
                                        </svg>
                                    </span>
                                    Aktif Et
                                </a>
                                <?php else: ?>
                                <?php if($plugin['settings']): ?>
                                <a data-bs-toggle="tooltip" title="Eklenti Ayarları" class="btn btn-info" href="<?= $plugin['settings']['url'] ?>" target="_blank">
                                    <span class="svg-icon svg-icon-2 mx-0">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.3" d="M20.859 12.596L17.736 13.596L10.388 20.944C10.2915 21.0406 10.1769 21.1172 10.0508 21.1695C9.9247 21.2218 9.78953 21.2486 9.65302 21.2486C9.5165 21.2486 9.3813 21.2218 9.25519 21.1695C9.12907 21.1172 9.01449 21.0406 8.918 20.944L2.29999 14.3229C2.10543 14.1278 1.99619 13.8635 1.99619 13.588C1.99619 13.3124 2.10543 13.0481 2.29999 12.853L11.853 3.29999C11.9495 3.20341 12.0641 3.12679 12.1902 3.07452C12.3163 3.02225 12.4515 2.9953 12.588 2.9953C12.7245 2.9953 12.8597 3.02225 12.9858 3.07452C13.1119 3.12679 13.2265 3.20341 13.323 3.29999L21.199 11.176C21.3036 11.2791 21.3797 11.4075 21.4201 11.5486C21.4605 11.6898 21.4637 11.8391 21.4295 11.9819C21.3953 12.1247 21.3249 12.2562 21.2249 12.3638C21.125 12.4714 20.9989 12.5514 20.859 12.596Z" fill="currentColor"></path>
                                            <path d="M14.8 10.184C14.7447 10.1843 14.6895 10.1796 14.635 10.1699L5.816 8.69997C5.55436 8.65634 5.32077 8.51055 5.16661 8.29469C5.01246 8.07884 4.95035 7.8106 4.99397 7.54897C5.0376 7.28733 5.18339 7.05371 5.39925 6.89955C5.6151 6.7454 5.88334 6.68332 6.14498 6.72694L14.963 8.19692C15.2112 8.23733 15.435 8.36982 15.59 8.56789C15.7449 8.76596 15.8195 9.01502 15.7989 9.26564C15.7784 9.51626 15.6642 9.75001 15.479 9.92018C15.2939 10.0904 15.0514 10.1846 14.8 10.184ZM17 18.6229C17 19.0281 17.0985 19.4272 17.287 19.7859C17.4755 20.1446 17.7484 20.4521 18.0821 20.6819C18.4158 20.9117 18.8004 21.0571 19.2027 21.1052C19.605 21.1534 20.0131 21.103 20.3916 20.9585C20.7702 20.814 21.1079 20.5797 21.3758 20.2757C21.6437 19.9716 21.8336 19.607 21.9293 19.2133C22.025 18.8195 22.0235 18.4085 21.925 18.0154C21.8266 17.6223 21.634 17.259 21.364 16.9569L19.843 15.257C19.7999 15.2085 19.7471 15.1697 19.688 15.1432C19.6289 15.1167 19.5648 15.1029 19.5 15.1029C19.4352 15.1029 19.3711 15.1167 19.312 15.1432C19.2529 15.1697 19.2001 15.2085 19.157 15.257L17.636 16.9569C17.2254 17.4146 16.9988 18.0081 17 18.6229ZM10.388 20.9409L17.736 13.5929H1.99999C1.99921 13.7291 2.02532 13.8643 2.0768 13.9904C2.12828 14.1165 2.2041 14.2311 2.29997 14.3279L8.91399 20.9409C9.01055 21.0381 9.12539 21.1152 9.25188 21.1679C9.37836 21.2205 9.51399 21.2476 9.65099 21.2476C9.78798 21.2476 9.92361 21.2205 10.0501 21.1679C10.1766 21.1152 10.2914 21.0381 10.388 20.9409Z" fill="currentColor"></path>
                                        </svg>
                                    </span>
                                    Ayarlar
                                </a>
                                <?php endif; ?>
                                <a data-bs-toggle="tooltip" title="Kapat" class="btn btn-warning btnAction" data-plugin="<?= $name ?>" data-action="deactive">
                                    <span class="svg-icon svg-icon-2 mx-0">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.3" d="M14 3V20H2V3C2 2.4 2.4 2 3 2H13C13.6 2 14 2.4 14 3ZM11 13V11C11 9.7 10.2 8.59995 9 8.19995V7C9 6.4 8.6 6 8 6C7.4 6 7 6.4 7 7V8.19995C5.8 8.59995 5 9.7 5 11V13C5 13.6 4.6 14 4 14V15C4 15.6 4.4 16 5 16H11C11.6 16 12 15.6 12 15V14C11.4 14 11 13.6 11 13Z" fill="currentColor"></path>
                                            <path d="M2 20H14V21C14 21.6 13.6 22 13 22H3C2.4 22 2 21.6 2 21V20ZM9 3V2H7V3C7 3.6 7.4 4 8 4C8.6 4 9 3.6 9 3ZM6.5 16C6.5 16.8 7.2 17.5 8 17.5C8.8 17.5 9.5 16.8 9.5 16H6.5ZM21.7 12C21.7 11.4 21.3 11 20.7 11H17.6C17 11 16.6 11.4 16.6 12C16.6 12.6 17 13 17.6 13H20.7C21.2 13 21.7 12.6 21.7 12ZM17 8C16.6 8 16.2 7.80002 16.1 7.40002C15.9 6.90002 16.1 6.29998 16.6 6.09998L19.1 5C19.6 4.8 20.2 5 20.4 5.5C20.6 6 20.4 6.60005 19.9 6.80005L17.4 7.90002C17.3 8.00002 17.1 8 17 8ZM19.5 19.1C19.4 19.1 19.2 19.1 19.1 19L16.6 17.9C16.1 17.7 15.9 17.1 16.1 16.6C16.3 16.1 16.9 15.9 17.4 16.1L19.9 17.2C20.4 17.4 20.6 18 20.4 18.5C20.2 18.9 19.9 19.1 19.5 19.1Z" fill="currentColor"></path>
                                        </svg>
                                    </span>
                                    Kapat
                                </a>
                                <?php endif; ?>
                                <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnAction" data-plugin="<?= $name ?>" data-action="remove">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor">
                                        <path fill="none" d="M0 0h24v24H0z"/>
                                        <path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/>
                                    </svg>
                                    Sil
                                </a>
                                <?php else: ?>
                                <a data-bs-toggle="tooltip" title="Kur" class="btn btn-success btnAction" data-plugin="<?= $name ?>" data-action="install">
                                    <span class="svg-icon svg-icon-2 mx-0">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.3" d="M4.05424 15.1982C8.34524 7.76818 13.5782 3.26318 20.9282 2.01418C21.0729 1.98837 21.2216 1.99789 21.3618 2.04193C21.502 2.08597 21.6294 2.16323 21.7333 2.26712C21.8372 2.37101 21.9144 2.49846 21.9585 2.63863C22.0025 2.7788 22.012 2.92754 21.9862 3.07218C20.7372 10.4222 16.2322 15.6552 8.80224 19.9462L4.05424 15.1982ZM3.81924 17.3372L2.63324 20.4482C2.58427 20.5765 2.5735 20.7163 2.6022 20.8507C2.63091 20.9851 2.69788 21.1082 2.79503 21.2054C2.89218 21.3025 3.01536 21.3695 3.14972 21.3982C3.28408 21.4269 3.42387 21.4161 3.55224 21.3672L6.66524 20.1802L3.81924 17.3372ZM16.5002 5.99818C16.2036 5.99818 15.9136 6.08615 15.6669 6.25097C15.4202 6.41579 15.228 6.65006 15.1144 6.92415C15.0009 7.19824 14.9712 7.49984 15.0291 7.79081C15.0869 8.08178 15.2298 8.34906 15.4396 8.55884C15.6494 8.76862 15.9166 8.91148 16.2076 8.96935C16.4986 9.02723 16.8002 8.99753 17.0743 8.884C17.3484 8.77046 17.5826 8.5782 17.7474 8.33153C17.9123 8.08486 18.0002 7.79485 18.0002 7.49818C18.0002 7.10035 17.8422 6.71882 17.5609 6.43752C17.2796 6.15621 16.8981 5.99818 16.5002 5.99818Z" fill="currentColor"></path>
                                            <path d="M4.05423 15.1982L2.24723 13.3912C2.15505 13.299 2.08547 13.1867 2.04395 13.0632C2.00243 12.9396 1.9901 12.8081 2.00793 12.679C2.02575 12.5498 2.07325 12.4266 2.14669 12.3189C2.22013 12.2112 2.31752 12.1219 2.43123 12.0582L9.15323 8.28918C7.17353 10.3717 5.4607 12.6926 4.05423 15.1982ZM8.80023 19.9442L10.6072 21.7512C10.6994 21.8434 10.8117 21.9129 10.9352 21.9545C11.0588 21.996 11.1903 22.0083 11.3195 21.9905C11.4486 21.9727 11.5718 21.9252 11.6795 21.8517C11.7872 21.7783 11.8765 21.6809 11.9402 21.5672L15.7092 14.8442C13.6269 16.8245 11.3061 18.5377 8.80023 19.9442ZM7.04023 18.1832L12.5832 12.6402C12.7381 12.4759 12.8228 12.2577 12.8195 12.032C12.8161 11.8063 12.725 11.5907 12.5653 11.4311C12.4057 11.2714 12.1901 11.1803 11.9644 11.1769C11.7387 11.1736 11.5205 11.2583 11.3562 11.4132L5.81323 16.9562L7.04023 18.1832Z" fill="currentColor"></path>
                                        </svg>
                                    </span>
                                    Kur
                                </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
                        </div>
                    </div>
                    <div class="footer py-4 d-flex flex-lg-column " id="kt_footer">
                        <div class=" container-xxl  d-flex flex-column flex-md-row align-items-center justify-content-between">
                            <div class="text-gray-900 order-2 order-md-1"> <span class="text-muted fw-semibold me-1"><?= date('Y') ?>&copy;</span> <a href="https://www.diyocp.com" target="_blank" class="text-gray-800 text-hover-primary"><?= beGetConfig('sitename') ?></a> </div>
                            <ul class="menu menu-gray-600 menu-hover-primary fw-semibold order-1">
                                <li class="menu-item"> <a href="https://wiki.diyocp.com" target="_blank" class="menu-link px-2">WIKI</a> </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="kt_scrolltop" class="scrolltop" data-kt-scrolltop="true">
            <i class="ki-duotone ki-arrow-up">
                <span class="path1"></span>
                <span class="path2"></span>
            </i> 
        </div>
        <script>
    $(".btnAction").on("click",function(){
        var action = $(this).data("action");
        var plugin = $(this).data("plugin");
        $.ajax({
            url: "<?= beGetRoute('admin.application.action.post') ?>",
            type: "post",
            data: {plugin:plugin,action:action},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    Swal.fire("Başarılı",response.message,"success");
                    setTimeout(function(){
                        location.reload();
                    },3000);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });	
    });
</script>
    </body>
</html>