<?php

namespace App\System\Middleware;

use App\System\Basic\beCache;
use App\System\Basic\beRouter;
use App\System\Model\UserGroupModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beLanguage;

class AdminMiddleware {
    //@ioncube.dk beEncrypt("be_diyocp","handle") -> "f884b2f4d6392ab447669f33514c9873" RANDOM
    public function handle($request = []){
        beLanguage::beReadLang("usergroup");
        $user = Auth::beGetUser();
        if(!$request["permission"]){
            $request["permission"] = "admin_dashboard";
        }
        if(!UserGroupModel::beCheckPermission(0,$request["permission"])){
            $method = beRouter::beGetMethod();
            if($method == "get"){
                beError(beGetLang("usergroup"),beGetLang("usergroup_permission_denied",["permission" => $request["permission"]]));
                exit;
            }
            else{
                echo beAjaxError(["message" => beGetLang("usergroup_permission_denied",["permission" => $request["permission"]])]);
                exit;
            }
        }
        global $be;
        $be->ticketstats = json_decode(beCache::beGetCache("stats_tickets"),true);
    }
}

?>