<?php

namespace App\System\Controller;

use App\System\Basic\beCache;
use App\System\Basic\beContoller;
use App\System\Model\LanguageModel;
use App\System\Model\PageTranslationsModel;
use App\System\Model\ProductTranslationsModel;

class SiteMapController extends beContoller {
    //@ioncube.dk beEncrypt("be_diyocp","main") -> "26912412c7a245848c4de43e302c903e" RANDOM
    public function main(){
        header("Access-Control-Allow-Origin: *");
        header("Content-Type: text/xml; charset=UTF-8");
        $languages = LanguageModel::beGetLanguages("lid,lcode");
        $siteurl = beGetConfig("siteurl");
        $xml = '<?xml version="1.0" encoding="UTF-8"?>'.PHP_EOL;
        $xml .= '<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">'.PHP_EOL;
        foreach($languages as $language){
            if($language["lid"] != 1){
                continue;
            }
            $xml .= "<sitemap>\n<loc>{$siteurl}/sitemap_{$language['lcode']}.xml</loc>\n<lastmod>".date("Y-m-d",strtotime("today"))."</lastmod>\n</sitemap>\n";
        }
        $xml .= '</sitemapindex>';
        return $xml;
    }
    //@ioncube.dk beEncrypt("be_diyocp","lang") -> "a0cba6a29d989c25f50ecf9a9678229f" RANDOM
    public function lang($lcode){
        header("Access-Control-Allow-Origin: *");
        header("Content-Type: text/xml; charset=UTF-8");
        $language = LanguageModel::beSelect("lid,lcode")->beWhere("lcode",$lcode)->beGet();
        if(!$language){
            beError("Bulunamadı!","Belirtilen dil bulunamadı!");
        }
        $page = (int)$_GET["page"]-1;
        if($page == -1){
            $page = 0;
        }
        $xml = '<?xml version="1.0" encoding="UTF-8"?>'.PHP_EOL;
        $xml .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">'.PHP_EOL;
        $cacheslug = "sitemap_".$lcode."_"."global";
        if(!beCache::beCacheExist($cacheslug."_info")){
            $xmldata = "";
            beCache::beSetCache($cacheslug."_info",json_encode([
                "cachetime" => 86400
            ]));
            $siteurl = beGetConfig("siteurl");
            $showitemcount = 100;
            $items = PageTranslationsModel::beSelect("ptid,ptslug,ptupdatedateline")->beWhere("lid",$language["lid"])->beWhere("p.ptype",["category","special"],"IN")->beJoin("INNER JOIN be_pages as p ON p.pid = be_pages_translations.pid")->beLimit($page*$showitemcount,$showitemcount)->beOrder("ptid","ASC")->beGetAll();
            foreach($items as $item){
                if($item["ptslug"] == "/"){
                    continue;
                }
                $xmldata .= "<url>\n<loc>{$siteurl}{$item['ptslug']}</loc>\n<lastmod>".date("Y-m-d",$item["ptupdatedateline"])."</lastmod>\n</url>\n";
            }
            /*$items = ProductTranslationsModel::beSelect("p.pid,ptid,pslug,p.pupdatedateline")->beWhere("lid",$language["lid"])->beJoin("INNER JOIN be_products as p ON p.pid = be_product_translations.pid")->beLimit($page*$showitemcount,$showitemcount)->beOrder("ptid","ASC")->beGetAll();
            foreach($items as $item){
                $xmldata .= "<url>\n<loc>".beGetRoute("product.product",["slug" => $item["pslug"]])."</loc>\n<lastmod>".date("Y-m-d",$item["pupdatedateline"])."</lastmod>\n</url>\n";
            }*/
            beCache::beSetCache($cacheslug."_content",$xmldata);
            $xml .= $xmldata;
        }
        else{
            $cache = json_decode(beCache::beGetCache($cacheslug."_info"),JSON_UNESCAPED_UNICODE);
            $xml .= beCache::beGetCache($cacheslug."_content");
            if($cache["cachetime"] && BE_TIME > $cache["cachetime"]){
                beCache::beDeleteCache([$cacheslug."_info",$cacheslug."_content"]);
            }
        }
        $xml .= '</urlset>';
        return $xml;
    }
}

?>