<?php

namespace App\System\Controller;

use App\System\Basic\beContoller;
use App\System\Model\ServerModel;
use App\System\Model\SettingGroupsModel;
use App\System\Model\SettingModel;
use App\System\Vendor\beLanguage;
use App\System\Vendor\beModule;
use App\System\Vendor\beUpload;

class SettingsController extends beContoller {
    //@ioncube.dk beEncrypt("be_diyocp","settinggroups") -> "937cb7aff2e47b881cbf5eb4ac9bfef0" RANDOM
    public function settinggroups(){
        $settinggroups = SettingGroupsModel::beGetAll();
        return beGetView("admin.settings.group.list",["settinggroups" => $settinggroups]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","settinggroup") -> "9a8453957027839e36b84092997890a9" RANDOM
    public function settinggroup($sgid = 0){
        $settinggroup = SettingGroupsModel::beWhere("sgid",$sgid)->beGet();
        $settings = SettingModel::beSelect("scode,stype,sname,sdescription,svalue")->beWhere("sgid",$settinggroup["sgid"])->beWhere("seditable","1")->beGetAll();
        return beGetView("admin.settings.group.show",["settinggroup" => $settinggroup,"settings" => $settings]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","save_post") -> "eecc7206f225c19b459c5422c180663b" RANDOM
    public function save_post(){
        beLanguage::beReadLang("setting");
        $sgid = (int)$_POST["sgid"];
        $settings = SettingModel::beSelect("sid,scode,sname,stype")->beWhere("sgid",$sgid)->beWhere("seditable","1")->beGetAll();
        foreach($settings as $setting){
            if(!isset($_POST[$setting["scode"]]) && !$_FILES[$setting["scode"]]){
                continue;
            }
            $types = explode(PHP_EOL,$setting["stype"]);
            $type = trim($types[0]);
            unset($types[0]);
            switch($type){
                case "int" :
                case "float" :
                case "str" :
                    SettingModel::beUpdate(["svalue" => $_POST[$setting["scode"]]])->beWhere("sid",$setting["sid"])->beExecute();
                    break;
                case "select" :
                case "multipleselect" :
                    SettingModel::beUpdate(["svalue" => $_POST[$setting["scode"]]])->beWhere("sid",$setting["sid"])->beExecute();
                    break;
                case "bool" :
                    if(isset($_POST[$setting["scode"]])){
                        SettingModel::beUpdate(["svalue" => "1"])->beWhere("sid",$setting["sid"])->beExecute();
                    }
                    else{
                        SettingModel::beUpdate(["svalue" => "0"])->beWhere("sid",$setting["sid"])->beExecute();
                    }
                case "img" :
                    $file = $_FILES[$setting["scode"]];
                    if($file["name"]){
                        $path = explode("=",$types[1])[1];
                        $upload = beUpload::beUploadFile($file,str_replace(" ","",$file["name"]),BE_ROOT.$path,0,null,false);
                        if(!$upload["status"]){
                            return beAjaxError(["message" => $upload["message"]." yüklenemedi!"]);
                        }
                        $fileurl = $path."/".$upload["filename"];
                        SettingModel::beUpdate(["svalue" => $fileurl])->beWhere("sid",$setting["sid"])->beExecute();
                    }
                    break;
            }
        }
        return beAjaxSuccess(["message" => beGetLang("settings_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","server") -> "11734724376f2bf0f901644bccd342c3" RANDOM
    public function server(){
        $servers = ServerModel::beSelect("sid,sname,surl,sstatus,sdateline")->beGetAll();
        return beGetView("admin.settings.server.list",["servers" => $servers]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","server_add") -> "5859b00ae6d2893b54460bee246a3e7d" RANDOM
    public function server_add(){
        $modules = beModule::beLoadModules("product");
        $modulelist = [];
        foreach($modules as $key => $module){
            $modulelist[$key] = $module["info"]["name"];
        }
        return beGetView("admin.settings.server.add",["modulelist" => $modulelist]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","server_add_post") -> "b96a61ac229f138053843b7441407a81" RANDOM
    public function server_add_post(){
        beLanguage::beReadLang("server");
        if(empty($_POST["name"]) || empty($_POST["url"]) || empty($_POST["username"])){
            return beAjaxError(["message" => beGetLang("server_compulsory_fields")]);
        }
        ServerModel::beInsert([
            "sname" => $_POST["name"],
            "smodule" => $_POST["module"],
            "surl" => $_POST["url"],
            "susername" => $_POST["username"],
            "spassword" => beEncryptData($_POST["password"]),
            "stoken" => $_POST["token"],
            "snameserver1" => $_POST["nameserver1"],
            "snameserver2" => $_POST["nameserver2"],
            "snameserver3" => $_POST["nameserver3"],
            "snameserver4" => $_POST["nameserver4"],
            "sstatus" => $_POST["status"],
            "sdateline" => BE_TIME
        ]);
        return beAjaxSuccess(["message" => beGetLang("server_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","server_edit") -> "ef41a03e5f99f459a00ab39cf32aaa10" RANDOM
    public function server_edit($sid){
        beLanguage::beReadLang("server");
        $server = ServerModel::beWhere("sid",$sid)->beGet();
        if(!$server){
            beError(beGetLang("server"),beGetLang("server_not_found"));
        }
        $modules = beModule::beLoadModules("product");
        $modulelist = [];
        foreach($modules as $key => $module){
            $modulelist[$key] = $module["info"]["name"];
        }
        $server["spassword"] = beDecryptData($server["spassword"]);
        return beGetView("admin.settings.server.edit",["server" => $server,"modulelist" => $modulelist]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","server_edit_post") -> "38de17b2bfdce71007a9bf304648124c" RANDOM
    public function server_edit_post(){
        beLanguage::beReadLang("server");
        $sid = (int)$_POST["sid"];
        $server = ServerModel::beSelect("sid")->beWhere("sid",$sid)->beGet();
        if(!$server){
            return beAjaxError(["message" => beGetLang("server_not_found")]);
        }
        ServerModel::beUpdate([
            "sname" => $_POST["name"],
            "smodule" => $_POST["module"],
            "surl" => $_POST["url"],
            "susername" => $_POST["username"],
            "spassword" => beEncryptData($_POST["password"]),
            "stoken" => $_POST["token"],
            "snameserver1" => $_POST["nameserver1"],
            "snameserver2" => $_POST["nameserver2"],
            "snameserver3" => $_POST["nameserver3"],
            "snameserver4" => $_POST["nameserver4"],
            "sstatus" => $_POST["status"],
        ])->beWhere("sid",$server["sid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("server_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","server_check_post") -> "3904811aaaba2659853d1570873647dd" RANDOM
    public function server_check_post(){
        beLanguage::beReadLang("server");
        beLanguage::beReadLang("module");
        $modulename = $_POST["module"];
        $module = beModule::beLoadModule("product.{$modulename}");
        if(!$module["status"]){
            return beAjaxError(["message" => beGetLang("module_not_found")]);
        }
        if(!beModule::beCheckModuleFunction($modulename,"connection_test")){
            return beAjaxError(["message" => beGetLang("module_connection_test_not_found")]);
        }
        $data = [
            "surl" => $_POST["url"],
            "susername" => $_POST["username"],
            "spassword" => $_POST["password"],
            "stoken" => $_POST["token"],
            "snameserver1" => $_POST["nameserver1"],
            "snameserver2" => $_POST["nameserver2"],
            "snameserver3" => $_POST["nameserver3"],
            "snameserver4" => $_POST["nameserver4"]  
        ];
        $response = beModule::beRunModuleFunction($modulename,"connection_test",$data);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("module_connection_test_successfully")]);
    }
}

?>