<?php

namespace App\System\Controller;
use App\System\Basic\beContoller;
use App\System\Model\LanguageModel;
use App\System\Model\MessageTemplateModel;
use App\System\Model\MessageTemplateTranslationsModel;
use App\System\Vendor\beLanguage;

class MessageTemplateController extends beContoller {
    //@ioncube.dk beEncrypt("be_diyocp","list") -> "9101db8b3142404cffbb15d98d4e633a" RANDOM
    public function list(){
        $categories = beLanguage::beReadLang("messagetemplate-categories");
        $names = beLanguage::beReadLang("messagetemplate-names");
        $messages = MessageTemplateModel::beGetAll();
        return beGetView("admin.messagetemplates.list",["messages" => $messages,"categories" => $categories,"names" => $names]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","edit") -> "ef2c86a2f570e9f43db63597a17bf569" RANDOM
    public function edit($mtid){
        beLanguage::beReadLang("messagetemplate");
        global $be;
        $messagetemplate = MessageTemplateModel::beSelect("mtid")->beWhere("mtid",$mtid)->beGet();
        if(!$messagetemplate){
            beError(beGetLang("messagetemplate"),beGetLang("messagetemplate_not_found"));
        }
        $messagelist = MessageTemplateTranslationsModel::beWhere("mtid",$mtid)->beGetAll();
        if(!$messagelist){
            beError(beGetLang("messagetemplate"),beGetLang("messagetemplate_not_found"));
        }
        $messages = [];
        foreach($messagelist as $message){
            $messages[(int)$message["lid"]][$message["mtttype"]] = $message;
        }
        $languages = LanguageModel::beGetLanguages("lid,lname");
        $systemlid = $be->settings["system_language"];
        return beGetView("admin.messagetemplates.edit",["messagetemplate" => $messagetemplate,"messages" => $messages,"languages" => $languages,"systemlid" => $systemlid]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","edit_post") -> "612153cbfbd9f0b9015947cac84fe756" RANDOM
    public function edit_post(){
        beLanguage::beReadLang("messagetemplate");
        $mtid = (int)$_POST["mtid"];
        $messagetemplate = MessageTemplateModel::beSelect("mtid")->beWhere("mtid",$mtid)->beGet();
        if(!$messagetemplate){
            return beAjaxError(["message" => beGetLang("messagetemplate_not_found")]);
        }
        $languages = LanguageModel::beGetLanguages("lid");
        foreach($languages as $language){
            $lid = (int)$language["lid"];
            foreach(["mail","alert","sms"] as $type){
                if(!$_POST["mttsubject"][$lid][$type]){
                    continue;
                }
                $subject = $_POST["mttsubject"][$lid][$type];
                $message = $_POST["mttmessage"][$lid][$type];
                $status = $_POST["mttstatus"][$lid][$type];
                $messagetemplatetranslation = MessageTemplateTranslationsModel::beSelect("mttid")->beWhere("mtid",$mtid)->beWhere("lid",$lid)->beWhere("mtttype",$type)->beGet();
                if($messagetemplatetranslation){
                    MessageTemplateTranslationsModel::beUpdate([
                        "mttsubject" => $subject,
                        "mttmessage" => $message,
                        "mttstatus" => $status
                    ])->beWhere("mttid",$messagetemplatetranslation["mttid"])->beExecute();
                }
                else{
                    MessageTemplateTranslationsModel::beInsert([
                        "mtid" => $mtid,
                        "lid" => $lid,
                        "mtttype" => $type,
                        "mttsubject" => $subject,
                        "mttmessage" => $message,
                        "mttstatus" => $status
                    ]);
                }
            }
        }
        return beAjaxSuccess(["message" => beGetLang("messagetemplate_updated")]);
    }
}

?>