<?php

namespace App\System\Controller;
use App\System\Basic\beContoller;
use App\System\Model\ProductModel;
use App\System\Model\UserInfoModel;
use App\System\Model\UserProductModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beAlert;
use App\System\Vendor\beMail;
use App\System\Vendor\beSms;

class MarketingController extends beContoller {
    public function list(){
        return beGetView("admin.marketing.list");
    }
    public function messageadd(){
        $products = ProductModel::beSelect("be_products.pid,pt.pname")->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = be_products.pid")->beGetAll();
        return beGetView("admin.marketing.add",["products" => $products]);
    }
    public function sendmessage_post(){
        $uidlist = [];
        $subject = $_POST["subject"];
        $message = $_POST["message"];
        $alert = $_POST["alert"] == 1 ? true:false;
        $sms = $_POST["sms"] == 1 ? true:false;
        $email = $_POST["email"] == 1 ? true:false;
        $onetime = $_POST["onetime"] == 1 ? true:false;
        $order = $_POST["order"] == 1 ? true:false;
        $blocked = $_POST["blocked"] == 1 ? true:false;
        $users = $_POST["users"];
        foreach($users as $uid){
            $uid = (int)$uid;
            $usercheck = Auth::beGetUser($uid,"uid");
            if($usercheck){
                if($order){
                    $userproducts = UserProductModel::beSelect("uid")->beWhere("uid",$uid)->beGet();
                    if($userproducts){
                        $uidlist[] = $uid;
                    }
                }
                else{
                    $uidlist[] = $uid;
                }
            }
        }
        $products = $_POST["products"];
        foreach($products as $pid){
            $pid = (int)$pid;
            $product = ProductModel::beSelect("pid")->beWhere("pid",$pid)->beGet();
            if($product){
                $userproducts = UserProductModel::beSelect("upid,uid")->beWhere("pid",$product["pid"])->beGetAll();
                if($onetime){
                    foreach($userproducts as  $userproduct){
                        if(in_array($userproduct["uid"],$uidlist)){
                            continue;
                        }
                        $uidlist[] = (int)$userproduct["uid"];
                    }
                }
                else{
                    foreach($userproducts as $userproduct){
                        $uidlist[] = (int)$userproduct["uid"];
                    }
                }
            }
        }
        $sitename = beGetConfig("sitename");
        foreach($uidlist as $uid){
            $userinfo = UserInfoModel::beSelect("uid,uisettings")->beWhere("uid",$uid)->beGet();
            $user = Auth::beGetUser("uid,name,surname,email",$uid);
            $sendalert = true;
            $sendsms = true;
            $sendmail = true;
            if($blocked){
                $uisettings = json_decode($userinfo["uisettings"],true);
                if($alert && $uisettings["notification_alert"]){
                    $sendalert = false;
                }
                if($sms && $uisettings["sms_alert"]){
                    $sendsms = false;
                }
                if($email && $uisettings["mail_alert"]){
                    $sendmail = false;
                }
            }
            $usermessageoriginal = str_replace(["{sitename}","{name}","{surname}","{namesurname}"],[$sitename,$user["name"],$user["surname"],$user["name"]." ".$user["surname"],$user["email"]],$message);
            if($alert && $sendalert){
                $usermessage = strip_tags($usermessageoriginal);
                beAlert::beCreateAlert(json_encode(["message" => $usermessage],JSON_UNESCAPED_UNICODE),"",$userinfo["uid"]);
            }
            if($sms && $sendsms){
                $usermessage = strip_tags($usermessageoriginal);
                beSms::beCreateSms($usermessage,1,$userinfo["uid"]);
            }
            if($email && $sendmail){
                beMail::beCreateMail($subject,$usermessageoriginal,2,1,$userinfo["uid"]);
            }
        }
        return beAjaxSuccess(["message" => "Başarılı bir şekilde belirtilen kullancılara mesaj gönderildi!"]);
    }
}

?>