<?php

namespace App\System\Controller;
use App\System\Basic\beContoller;
use App\System\Model\AuthModel;
use App\System\Model\SettingModel;
use App\System\Model\SettingsModel;
use App\System\Model\UserInfoModel;
use App\System\Vendor\Auth;
use App\System\Vendor\Basic\beCookie;
use App\System\Vendor\beLanguage;
use App\System\Vendor\beTask;

class InstallController extends beContoller {
    public function install(){
        global $be;
        $status = $be->settings["system_status"];
        if($status != 1){
            beError("Zaten Kurulu","Sistem zaten aktif bu sayfaya erişemezsiniz");
        }
        return beGetView("install");
    }
    public function install_post(){
        global $be;
        $status = $be->settings["system_status"];
        if($status != 1){
            return beAjaxError(["message" => "Sistem zaten aktif bu sayfaya erişemezsiniz"]);
        }
        $action = $_POST["action"];
        switch($action){
            case "checkstep" :
                $step = (int)$_POST["step"];
                switch($step){
                    case 1 :
                        return beAjaxSuccess([]);
                        break;
                    case 2 :
                        $lisancekey = $_POST["lisance_key"];
                        list($id,$token) = explode(":",$lisancekey);
                        $response = ConnectionController::beSendRequestControlPanel([
                            "method" => "checkuser",
                            "data" => [
                                "cid" => $id,
                                "ctoken" => $token,
                                "secret" => md5($_SERVER["HTTP_HOST"]."1453".$_SERVER["SERVER_ADDR"]),
                            ]
                        ]);
                        if(!$response["status"]){
                            return beAjaxError(["message" => $response["message"]]);
                        }
                        return beAjaxSuccess([]);
                        break;
                    case 3 :
                        beLanguage::beReadLang("auth");
                        beLanguage::beReadLang("form");
                        $name = $_POST["name"];
                        $surname = $_POST["surname"];
                        $email = $_POST["email"];
                        $password1 = $_POST["password1"];
                        $password2 = $_POST["password2"];
                        if(empty($name) || empty($surname) || empty($email) || empty($password1) || empty($password2)){
                            return beAjaxError(["message" => beGetLang("form_not_full")]);
                        }
                        if(!filter_var($email,FILTER_VALIDATE_EMAIL)){
                            return beAjaxError(["message" => beGetLang("form_not_full")]);
                        }
                        if(strlen($password1) < 5){
                            return beAjaxError(["message" => beGetLang("password_min_length",["minlength" => 5])]);
                        }
                        if($password1 != $password2){
                            return beAjaxError(["message" => beGetLang("password_not_match")]);
                        }
                        return beAjaxSuccess([]);
                        break;
                }
                break;
            case "create" :
                beLanguage::beReadLang("auth");
                beLanguage::beReadLang("form");
                $lisancekey = $_POST["lisance_key"];
                list($id,$token) = explode(":",$lisancekey);
                $secret = md5($_SERVER["HTTP_HOST"]."1453".$_SERVER["SERVER_ADDR"]);
                $response = ConnectionController::beSendRequestControlPanel([
                    "method" => "checkuser",
                    "data" => [
                        "cid" => $id,
                        "ctoken" => $token,
                        "secret" => $secret,
                    ]
                ]);
                if(!$response["status"]){
                    return beAjaxError(["message" => $response["message"]]);
                }
                $name = $_POST["name"];
                $surname = $_POST["surname"];
                $email = $_POST["email"];
                $password1 = $_POST["password1"];
                $password2 = $_POST["password2"];
                if(empty($name) || empty($surname) || empty($email) || empty($password1) || empty($password2)){
                    return beAjaxError(["message" => beGetLang("form_not_full")]);
                }
                if(!filter_var($email,FILTER_VALIDATE_EMAIL)){
                    return beAjaxError(["message" => beGetLang("form_not_full")]);
                }
                if(strlen($password1) < 5){
                    return beAjaxError(["message" => beGetLang("password_min_length",["minlength" => 5])]);
                }
                if($password1 != $password2){
                    return beAjaxError(["message" => beGetLang("password_not_match")]);
                }
                SettingModel::beUpdate(["svalue" => 2])->beWhere("scode","system_status")->beExecute();
                SettingModel::beUpdate(["svalue" => $id])->beWhere("scode","system_id")->beExecute();
                SettingModel::beUpdate(["svalue" => $token])->beWhere("scode","system_token")->beExecute();
                SettingModel::beUpdate(["svalue" => $secret])->beWhere("scode","system_secret")->beExecute();
                beTask::beRunTask(["tfilename" => "LisanceCheck"]);
                $user = Auth::beCreateUser(["name" => $name,"surname" => $surname,"email" => $email,"password" => $password1,"usergroup" => 4,"extradata" => ["lid" => $be->settings["system_language"],"cid" => $be->settings["system_currency"],"status" => "1"]]);
                $usersettings = [
                    "sms_alert" => 1,
                    "mail_alert" => 1,
                    "notification_alert" => 1,
                    "order_auto_pay" => 0,
                    "never_suspend" => 0,
                    "never_terminate" => 0,
                    "invoice_tax_exemption" => 0,
                    "invoice_latefee" => 1,
                    "ticket_create" => 1,
                    "ticket_onlyone" => 0,
                    "ticket_files" => 1,
                    "invoiceinfo" => 1,
                    "productinfo" => 1,
                    "invoiceinfo" => 1,
                ];
                UserInfoModel::beInsert([
                    "uid" => $user["uid"],
                    "acid" => 218,
                    "uidistrict" => "TR",
                    "uiprovince" => "TR",
                    "uidial" => 90,
                    "uiphone" => "",
                    "uiaddress" => "",
                    "uisettings" => json_encode($usersettings,JSON_UNESCAPED_UNICODE)
                ]);
                beCookie::beCreateCookie("be_user",$user["uid"]."_".$user["loginkey"],true,true);
                return beAjaxSuccess(["message" => "Başarılı bir şekilde sistem kurulumu tamamlandı","url" => beGetConfig("siteurl")]);
                break;
        }
    }
}

?>